<?php
// Script to verify questions count for each job role

try {
    // Database connection
    $pdo = new PDO('mysql:host=localhost;dbname=oacsoft_cbt', 'root', '');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Get question counts for each job role
    $query = "
        SELECT 
            jr.role_name,
            COUNT(q.id) as question_count
        FROM job_roles jr
        LEFT JOIN questions q ON jr.id = q.job_role_id
        GROUP BY jr.id, jr.role_name
        ORDER BY jr.id
    ";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Question Count Summary:\n";
    echo "======================\n";
    
    foreach ($results as $row) {
        echo sprintf("%-35s: %d questions\n", $row['role_name'], $row['question_count']);
    }
    
    echo "\nTotal questions in database: " . array_sum(array_column($results, 'question_count')) . "\n";
    
} catch (PDOException $e) {
    echo "Database error: " . $e->getMessage() . "\n";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>