<?php include 'includes/header.php'; ?>

<?php
$token = $_GET['token'] ?? '';
$error = '';
$success = '';
$valid_token = false;
$user_data = null;

if (empty($token)) {
    $error = "Invalid reset link. Please request a new password reset.";
} else {
    // Check if token exists and is valid
    $stmt = $conn->prepare("
        SELECT prt.*, u.id as user_id, u.full_name, u.email 
        FROM password_reset_tokens prt 
        JOIN users u ON prt.user_id = u.id 
        WHERE prt.token = ? AND prt.expires_at > NOW() AND prt.used = FALSE
    ");
    $stmt->execute([$token]);
    $token_data = $stmt->fetch();
    
    if (!$token_data) {
        $error = "Invalid or expired reset link. Please request a new password reset.";
    } else {
        $valid_token = true;
        $user_data = $token_data;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $valid_token) {
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    
    // Validate password
    if (empty($password)) {
        $error = "Password is required.";
    } elseif (strlen($password) < 6) {
        $error = "Password must be at least 6 characters long.";
    } elseif ($password !== $confirm_password) {
        $error = "Passwords do not match.";
    } else {
        // Hash the new password
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        
        // Update user password
        $stmt = $conn->prepare("UPDATE users SET password = ?, updated_at = NOW() WHERE id = ?");
        $update_success = $stmt->execute([$hashed_password, $user_data['user_id']]);
        
        if ($update_success) {
            // Mark token as used
            $stmt = $conn->prepare("UPDATE password_reset_tokens SET used = TRUE WHERE token = ?");
            $stmt->execute([$token]);
            
            $success = "Your password has been successfully reset. You can now login with your new password.";
            $valid_token = false; // Hide the form
        } else {
            $error = "Failed to update password. Please try again.";
        }
    }
}
?>

<div class="login-container">
    <div class="card">
        <div class="card-header text-center">
            <h4 class="mb-0">
                <i class="fas fa-lock me-2"></i>
                Reset Password
            </h4>
        </div>
        <div class="card-body">
            <?php if ($success): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle me-2"></i>
                    <?php echo $success; ?>
                </div>
                <div class="text-center mt-3">
                    <a href="login.php" class="btn btn-primary">
                        <i class="fas fa-sign-in-alt me-2"></i>
                        Login Now
                    </a>
                </div>
            <?php elseif ($error): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <?php echo $error; ?>
                </div>
                <div class="text-center mt-3">
                    <a href="forgot-password.php" class="btn btn-primary">
                        <i class="fas fa-redo me-2"></i>
                        Request New Reset Link
                    </a>
                </div>
            <?php elseif ($valid_token): ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    Hello <strong><?php echo htmlspecialchars($user_data['full_name']); ?></strong>, 
                    please enter your new password below.
                </div>

                <form method="POST" id="resetForm">
                    <div class="mb-3">
                        <label for="password" class="form-label">
                            <i class="fas fa-lock me-2"></i>
                            New Password
                        </label>
                        <div class="input-group">
                            <input type="password" class="form-control" id="password" name="password" required 
                                   placeholder="Enter new password" minlength="6">
                            <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                <i class="fas fa-eye" id="toggleIcon"></i>
                            </button>
                        </div>
                        <div class="form-text">
                            <i class="fas fa-info-circle me-1"></i>
                            Password must be at least 6 characters long
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">
                            <i class="fas fa-lock me-2"></i>
                            Confirm New Password
                        </label>
                        <div class="input-group">
                            <input type="password" class="form-control" id="confirm_password" name="confirm_password" required 
                                   placeholder="Confirm new password">
                            <button class="btn btn-outline-secondary" type="button" id="toggleConfirmPassword">
                                <i class="fas fa-eye" id="toggleConfirmIcon"></i>
                            </button>
                        </div>
                        <div id="passwordMatch" class="form-text"></div>
                    </div>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary" id="submitBtn">
                            <i class="fas fa-save me-2"></i>
                            Reset Password
                        </button>
                    </div>
                </form>

                <div class="text-center mt-3">
                    <a href="login.php" class="text-decoration-none">
                        <i class="fas fa-arrow-left me-2"></i>
                        Back to Login
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.login-container {
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    background: white;
    padding: 20px;
}

.card {
    width: 100%;
    max-width: 450px;
    border: none;
    border-radius: 15px;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
    overflow: hidden;
}

.card-header {
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    color: white;
    padding: 2rem 1.5rem;
    border-bottom: none;
}

.card-body {
    padding: 2rem 1.5rem;
    background: white;
}

.form-control {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    padding: 12px 15px;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #3b82f6;
    box-shadow: 0 0 0 0.2rem rgba(59, 130, 246, 0.25);
}

.input-group .btn {
    border-radius: 0 10px 10px 0;
    border: 2px solid #e2e8f0;
    border-left: none;
}

.input-group .form-control {
    border-radius: 10px 0 0 10px;
}

.btn-primary {
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    border: none;
    border-radius: 10px;
    padding: 12px 20px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #1d4ed8, #1e40af);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(59, 130, 246, 0.3);
}

.btn-primary:disabled {
    background: #94a3b8;
    transform: none;
    box-shadow: none;
}

.alert {
    border-radius: 10px;
    border: none;
    padding: 15px 20px;
}

.alert-success {
    background: linear-gradient(135deg, #10b981, #059669);
    color: white;
}

.alert-danger {
    background: linear-gradient(135deg, #ef4444, #dc2626);
    color: white;
}

.alert-info {
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    color: white;
}

.form-text {
    font-size: 0.875rem;
    margin-top: 0.5rem;
}

.text-success {
    color: #10b981 !important;
}

.text-danger {
    color: #ef4444 !important;
}

@media (max-width: 576px) {
    .login-container {
        padding: 10px;
    }
    
    .card-body {
        padding: 1.5rem 1rem;
    }
    
    .card-header {
        padding: 1.5rem 1rem;
    }
}
</style>

<script>
// Toggle password visibility
document.getElementById('togglePassword')?.addEventListener('click', function() {
    const passwordField = document.getElementById('password');
    const toggleIcon = document.getElementById('toggleIcon');
    
    if (passwordField.type === 'password') {
        passwordField.type = 'text';
        toggleIcon.classList.remove('fa-eye');
        toggleIcon.classList.add('fa-eye-slash');
    } else {
        passwordField.type = 'password';
        toggleIcon.classList.remove('fa-eye-slash');
        toggleIcon.classList.add('fa-eye');
    }
});

document.getElementById('toggleConfirmPassword')?.addEventListener('click', function() {
    const confirmPasswordField = document.getElementById('confirm_password');
    const toggleConfirmIcon = document.getElementById('toggleConfirmIcon');
    
    if (confirmPasswordField.type === 'password') {
        confirmPasswordField.type = 'text';
        toggleConfirmIcon.classList.remove('fa-eye');
        toggleConfirmIcon.classList.add('fa-eye-slash');
    } else {
        confirmPasswordField.type = 'password';
        toggleConfirmIcon.classList.remove('fa-eye-slash');
        toggleConfirmIcon.classList.add('fa-eye');
    }
});

// Password matching validation
function checkPasswordMatch() {
    const password = document.getElementById('password').value;
    const confirmPassword = document.getElementById('confirm_password').value;
    const matchDiv = document.getElementById('passwordMatch');
    const submitBtn = document.getElementById('submitBtn');
    
    if (confirmPassword.length > 0) {
        if (password === confirmPassword) {
            matchDiv.innerHTML = '<i class="fas fa-check me-1 text-success"></i><span class="text-success">Passwords match</span>';
            submitBtn.disabled = false;
        } else {
            matchDiv.innerHTML = '<i class="fas fa-times me-1 text-danger"></i><span class="text-danger">Passwords do not match</span>';
            submitBtn.disabled = true;
        }
    } else {
        matchDiv.innerHTML = '';
        submitBtn.disabled = false;
    }
}

document.getElementById('password')?.addEventListener('input', checkPasswordMatch);
document.getElementById('confirm_password')?.addEventListener('input', checkPasswordMatch);

// Form validation
document.getElementById('resetForm')?.addEventListener('submit', function(e) {
    const password = document.getElementById('password').value;
    const confirmPassword = document.getElementById('confirm_password').value;
    
    if (password.length < 6) {
        e.preventDefault();
        Swal.fire({
            icon: 'error',
            title: 'Invalid Password',
            text: 'Password must be at least 6 characters long.'
        });
        return;
    }
    
    if (password !== confirmPassword) {
        e.preventDefault();
        Swal.fire({
            icon: 'error',
            title: 'Password Mismatch',
            text: 'Passwords do not match.'
        });
        return;
    }
});
</script>

<?php include 'includes/footer.php'; ?>