<?php include 'includes/header.php'; ?>

<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = sanitize($_POST['email']);
    $password = $_POST['password'];
    
    $stmt = $conn->prepare("SELECT id, full_name, email, password, role, status FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password'])) {
        if ($user['status'] === 'approved') {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['full_name'];
            $_SESSION['user_email'] = $user['email'];
            $_SESSION['user_role'] = $user['role'];
            
            if ($user['role'] === 'admin') {
                redirect('admin/dashboard.php');
            } else {
                redirect('candidate/dashboard.php');
            }
        } elseif ($user['status'] === 'pending') {
            $error = "Your registration is pending approval. Please wait for admin approval.";
        } else {
            $error = "Your registration has been rejected. Please contact support.";
        }
    } else {
        $error = "Invalid email or password.";
    }
}
?>

<div class="login-container">
    <div class="card">
        <div class="card-header text-center">
            <h4 class="mb-0">
                <i class="fas fa-sign-in-alt me-2"></i>
                Login to CBT System
            </h4>
        </div>
        <div class="card-body">
            <?php if (isset($error)): ?>
                <div class="alert alert-danger">
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="mb-3">
                    <label for="email" class="form-label">Email Address</label>
                    <input type="email" 
                           class="form-control" 
                           id="email" 
                           name="email" 
                           required
                           value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>">
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <input type="password" 
                           class="form-control" 
                           id="password" 
                           name="password" 
                           required>
                </div>

                <div class="mb-3 form-check">
                    <input type="checkbox" 
                           class="form-check-input" 
                           id="remember" 
                           name="remember">
                    <label class="form-check-label" for="remember">
                        Remember me
                    </label>
                </div>

                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-sign-in-alt me-2"></i>
                    Login
                </button>
            </form>

            <div class="text-center mt-3">
                <p class="mb-2">
                    <a href="forgot-password.php">Forgot your password?</a>
                </p>
                <p class="mb-0">
                    Don't have an account? 
                    <a href="register.php">Register here</a>
                </p>
            </div>

            <hr class="my-4">
            
            <div class="text-center">
                <small class="text-muted">
                    <strong>Demo Accounts:</strong><br>
                    Admin: admin@oacsoft.com / admin123<br>
                    Candidate: Register first, then login
                </small>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>