<?php 
include 'includes/header.php'; 
?>

<script>
// Add landing-page class to body for specific styling
document.body.classList.add('landing-page');
</script>

<!-- Hero Section - Full Width Professional -->
<section class="hero-section-wide">
    <div class="hero-overlay"></div>
    <div class="hero-content-wrapper">
        <div class="hero-full-width">
            <div class="hero-inner-content">
                <div class="hero-content-professional" data-aos="fade-up">
                        <div class="hero-badge-professional mb-4">
                            <span class="badge-text">
                                <i class="fas fa-award me-2"></i>
                                #1 Computer-Based Testing Platform
                            </span>
                        </div>
                        
                        <h1 class="hero-title-professional mb-4">
                            Transform Your <span class="highlight-text">Recruitment Process</span><br>
                            with Advanced CBT Technology
                        </h1>
                        
                        <p class="hero-subtitle-professional mb-5">
                            Streamline hiring with our enterprise-grade testing platform. Trusted by Fortune 500 companies 
                            worldwide for secure, scalable, and intelligent candidate assessment.
                        </p>

                        <div class="hero-actions mb-5">
                            <?php if (!isLoggedIn()): ?>
                                <a href="register.php" class="btn btn-primary-professional btn-lg me-4">
                                    <i class="fas fa-rocket me-2"></i>Start Free Trial
                                </a>
                                <a href="#demo" class="btn btn-outline-professional btn-lg">
                                    <i class="fas fa-play me-2"></i>Watch Demo
                                </a>
                            <?php else: ?>
                                <?php if ($_SESSION['user_role'] === 'admin'): ?>
                                    <a href="admin/dashboard.php" class="btn btn-primary-professional btn-lg me-4">
                                        <i class="fas fa-tachometer-alt me-2"></i>Go to Dashboard
                                    </a>
                                <?php else: ?>
                                    <a href="candidate/dashboard.php" class="btn btn-primary-professional btn-lg me-4">
                                        <i class="fas fa-user-circle me-2"></i>My Dashboard
                                    </a>
                                <?php endif; ?>
                                <a href="logout.php" class="btn btn-outline-professional btn-lg">
                                    <i class="fas fa-sign-out-alt me-2"></i>Logout
                                </a>
                            <?php endif; ?>
                        </div>

                        <div class="hero-metrics">
                            <div class="row">
                                <div class="col-md-3 col-6">
                                    <div class="metric-item">
                                        <div class="metric-number" data-count="50000">50,000+</div>
                                        <div class="metric-label">Candidates Tested</div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-6">
                                    <div class="metric-item">
                                        <div class="metric-number" data-count="1200">1,200+</div>
                                        <div class="metric-label">Companies</div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-6">
                                    <div class="metric-item">
                                        <div class="metric-number">99.9%</div>
                                        <div class="metric-label">Uptime SLA</div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-6">
                                    <div class="metric-item">
                                        <div class="metric-number">24/7</div>
                                        <div class="metric-label">Support</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features Section - Wide Professional -->
<section class="features-section-wide" id="features">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 text-center mb-5" data-aos="fade-up">
                <h2 class="section-title-professional">
                    Enterprise Features Built for Scale
                </h2>
                <p class="section-subtitle-professional">
                    Comprehensive testing capabilities that adapt to your organization's unique requirements
                </p>
            </div>
        </div>

        <!-- Main Features Grid -->
        <div class="features-grid">
            <div class="feature-card-wide" data-aos="fade-up" data-aos-delay="100">
                <div class="feature-content-left">
                    <div class="feature-icon-large">
                        <i class="fas fa-brain"></i>
                    </div>
                    <h3>AI-Powered Assessment Engine</h3>
                    <p>Advanced machine learning algorithms automatically adapt question difficulty based on candidate performance, ensuring accurate skill evaluation across all competency levels.</p>
                    <ul class="feature-benefits-list">
                        <li><i class="fas fa-check"></i>Adaptive question selection</li>
                        <li><i class="fas fa-check"></i>Real-time difficulty adjustment</li>
                        <li><i class="fas fa-check"></i>Predictive analytics</li>
                    </ul>
                </div>
                <div class="feature-visual-right">
                    <div class="visual-placeholder ai-visual">
                        <i class="fas fa-robot"></i>
                        <span>AI Engine</span>
                    </div>
                </div>
            </div>

            <div class="feature-card-wide reverse" data-aos="fade-up" data-aos-delay="200">
                <div class="feature-visual-left">
                    <div class="visual-placeholder security-visual">
                        <i class="fas fa-shield-alt"></i>
                        <span>Enterprise Security</span>
                    </div>
                </div>
                <div class="feature-content-right">
                    <div class="feature-icon-large">
                        <i class="fas fa-lock"></i>
                    </div>
                    <h3>Military-Grade Security</h3>
                    <p>End-to-end encryption, advanced proctoring, and comprehensive audit trails ensure complete data protection and test integrity at every level.</p>
                    <ul class="feature-benefits-list">
                        <li><i class="fas fa-check"></i>256-bit SSL encryption</li>
                        <li><i class="fas fa-check"></i>Blockchain verification</li>
                        <li><i class="fas fa-check"></i>GDPR & SOC 2 compliant</li>
                    </ul>
                </div>
            </div>

            <div class="feature-card-wide" data-aos="fade-up" data-aos-delay="300">
                <div class="feature-content-left">
                    <div class="feature-icon-large">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3>Advanced Analytics Dashboard</h3>
                    <p>Comprehensive reporting with real-time insights, performance trends, and detailed candidate analytics to make data-driven hiring decisions.</p>
                    <ul class="feature-benefits-list">
                        <li><i class="fas fa-check"></i>Real-time performance tracking</li>
                        <li><i class="fas fa-check"></i>Customizable reports</li>
                        <li><i class="fas fa-check"></i>Predictive hiring insights</li>
                    </ul>
                </div>
                <div class="feature-visual-right">
                    <div class="visual-placeholder analytics-visual">
                        <i class="fas fa-chart-bar"></i>
                        <span>Live Analytics</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Features Row -->
        <div class="additional-features" data-aos="fade-up" data-aos-delay="400">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <div class="feature-card-compact">
                        <div class="feature-icon-compact">
                            <i class="fas fa-globe"></i>
                        </div>
                        <h4>Global Infrastructure</h4>
                        <p>99.9% uptime with CDN deployment across 6 continents for optimal performance.</p>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="feature-card-compact">
                        <div class="feature-icon-compact">
                            <i class="fas fa-mobile-alt"></i>
                        </div>
                        <h4>Multi-Platform Support</h4>
                        <p>Native mobile apps and responsive design for seamless testing on any device.</p>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="feature-card-compact">
                        <div class="feature-icon-compact">
                            <i class="fas fa-users-cog"></i>
                        </div>
                        <h4>Role-Based Access</h4>
                        <p>Granular permissions and role management for secure organizational control.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Trusted Companies Section -->
<section class="trusted-companies-section">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 text-center mb-4" data-aos="fade-up">
                <p class="trusted-text">Trusted by 1,200+ companies worldwide</p>
            </div>
        </div>
        <div class="companies-logos" data-aos="fade-up" data-aos-delay="200">
            <div class="logo-item">Microsoft</div>
            <div class="logo-item">Google</div>
            <div class="logo-item">Amazon</div>
            <div class="logo-item">Deloitte</div>
            <div class="logo-item">IBM</div>
            <div class="logo-item">Accenture</div>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="testimonials-section">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 text-center mb-5" data-aos="fade-up">
                <h2 class="section-title-professional">
                    What Our Clients Say
                </h2>
                <p class="section-subtitle-professional">
                    Hear from HR leaders and recruiting professionals worldwide
                </p>
            </div>
        </div>
        
        <div class="testimonials-grid">
            <div class="testimonial-card" data-aos="fade-up" data-aos-delay="100">
                <div class="testimonial-content">
                    <div class="quote-icon">
                        <i class="fas fa-quote-left"></i>
                    </div>
                    <p class="testimonial-text">
                        "OACSOFT CBT has revolutionized our hiring process. We've reduced our screening time by 75% 
                        and significantly improved the quality of candidates reaching final interviews."
                    </p>
                </div>
                <div class="testimonial-author">
                    <div class="author-info">
                        <h4>Sarah Johnson</h4>
                        <p>VP of Talent Acquisition, TechCorp Inc.</p>
                    </div>
                </div>
            </div>

            <div class="testimonial-card" data-aos="fade-up" data-aos-delay="200">
                <div class="testimonial-content">
                    <div class="quote-icon">
                        <i class="fas fa-quote-left"></i>
                    </div>
                    <p class="testimonial-text">
                        "The AI-powered analytics provide incredible insights into candidate performance. 
                        Our hiring accuracy has improved by 60% since implementing this platform."
                    </p>
                </div>
                <div class="testimonial-author">
                    <div class="author-info">
                        <h4>Michael Chen</h4>
                        <p>Chief HR Officer, Global Solutions Ltd.</p>
                    </div>
                </div>
            </div>

            <div class="testimonial-card" data-aos="fade-up" data-aos-delay="300">
                <div class="testimonial-content">
                    <div class="quote-icon">
                        <i class="fas fa-quote-left"></i>
                    </div>
                    <p class="testimonial-text">
                        "Enterprise-grade security and compliance features give us complete confidence. 
                        The platform scales perfectly with our global recruitment needs."
                    </p>
                </div>
                <div class="testimonial-author">
                    <div class="author-info">
                        <h4>Emma Rodriguez</h4>
                        <p>Director of Recruitment, Fortune 500 Company</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section - Professional -->
<section class="cta-section-professional">
    <div class="container-fluid">
        <div class="cta-background-overlay"></div>
        <div class="row">
            <div class="col-lg-8 offset-lg-2 text-center" data-aos="zoom-in">
                <div class="cta-content-professional">
                    <h2 class="cta-title-professional">
                        Ready to Transform Your Recruitment Process?
                    </h2>
                    <p class="cta-subtitle-professional">
                        Join 1,200+ companies using our enterprise CBT platform to hire better candidates faster.
                        Start your free trial today - no credit card required.
                    </p>
                    
                    <div class="cta-actions-professional">
                        <?php if (!isLoggedIn()): ?>
                            <a href="register.php" class="btn btn-primary-professional btn-xl me-4">
                                <i class="fas fa-rocket me-2"></i>Start Free Trial
                            </a>
                            <a href="#features" class="btn btn-outline-professional-white btn-xl">
                                <i class="fas fa-play me-2"></i>Schedule Demo
                            </a>
                        <?php else: ?>
                            <?php if ($_SESSION['user_role'] === 'admin'): ?>
                                <a href="admin/dashboard.php" class="btn btn-primary-professional btn-xl me-4">
                                    <i class="fas fa-tachometer-alt me-2"></i>Go to Dashboard
                                </a>
                            <?php else: ?>
                                <a href="candidate/dashboard.php" class="btn btn-primary-professional btn-xl me-4">
                                    <i class="fas fa-user-circle me-2"></i>My Dashboard
                                </a>
                            <?php endif; ?>
                            <a href="logout.php" class="btn btn-outline-professional-white btn-xl">
                                <i class="fas fa-sign-out-alt me-2"></i>Logout
                            </a>
                        <?php endif; ?>
                    </div>

                    <div class="cta-guarantees">
                        <div class="guarantee-item">
                            <i class="fas fa-shield-alt"></i>
                            <span>30-day free trial</span>
                        </div>
                        <div class="guarantee-item">
                            <i class="fas fa-times"></i>
                            <span>No setup fees</span>
                        </div>
                        <div class="guarantee-item">
                            <i class="fas fa-headset"></i>
                            <span>24/7 expert support</span>
                        </div>
                        <div class="guarantee-item">
                            <i class="fas fa-undo-alt"></i>
                            <span>Cancel anytime</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Professional Wide Layout Styles */

/* Hero Section - Full Width Professional */
.hero-section-wide {
    background: linear-gradient(135deg, #0f1419 0%, #1a2332 50%, #2c3e50 100%);
    min-height: 100vh;
    width: 100vw;
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    margin: 0;
    padding: 0;
    left: 50%;
    right: 50%;
    margin-left: -50vw;
    margin-right: -50vw;
}

.hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at 30% 20%, rgba(59, 130, 246, 0.15) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(16, 185, 129, 0.1) 0%, transparent 50%);
}

.hero-content-wrapper {
    position: relative;
    z-index: 2;
    width: 100%;
}

.hero-full-width {
    width: 100%;
    padding: 0;
    margin: 0;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
}

.hero-inner-content {
    max-width: 1200px;
    width: 100%;
    padding: 0 2rem;
    text-align: center;
}

/* Ensure body and html don't constrain width - only for landing page */
body.landing-page {
    overflow-x: hidden;
}

/* Full width breakout utility */
.full-width {
    width: 100vw;
    position: relative;
    left: 50%;
    right: 50%;
    margin-left: -50vw;
    margin-right: -50vw;
}

.hero-content-professional {
    color: white;
    max-width: none;
}

.hero-badge-professional {
    margin-bottom: 2rem;
}

.badge-text {
    background: linear-gradient(135deg, rgba(59, 130, 246, 0.2), rgba(16, 185, 129, 0.2));
    border: 1px solid rgba(59, 130, 246, 0.3);
    padding: 0.75rem 1.5rem;
    border-radius: 50px;
    font-size: 0.95rem;
    font-weight: 500;
    color: #e2e8f0;
    backdrop-filter: blur(10px);
    display: inline-block;
}

.hero-title-professional {
    font-size: 4rem;
    font-weight: 700;
    line-height: 1.1;
    margin-bottom: 2rem;
    color: #ffffff;
}

.highlight-text {
    background: linear-gradient(135deg, #3b82f6, #10b981);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.hero-subtitle-professional {
    font-size: 1.25rem;
    line-height: 1.7;
    color: #cbd5e1;
    margin-bottom: 3rem;
    font-weight: 400;
}

.hero-actions {
    margin-bottom: 4rem;
}

.btn-primary-professional {
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    border: none;
    padding: 1rem 2.5rem;
    font-size: 1.1rem;
    font-weight: 600;
    border-radius: 50px;
    color: white;
    text-decoration: none;
    transition: all 0.3s ease;
    box-shadow: 0 10px 25px rgba(59, 130, 246, 0.3);
}

.btn-primary-professional:hover {
    transform: translateY(-2px);
    box-shadow: 0 15px 35px rgba(59, 130, 246, 0.4);
    background: linear-gradient(135deg, #1d4ed8, #1e40af);
    color: white;
}

.btn-outline-professional {
    border: 2px solid rgba(255, 255, 255, 0.3);
    background: transparent;
    padding: 1rem 2rem;
    font-size: 1.1rem;
    font-weight: 600;
    border-radius: 50px;
    color: white;
    text-decoration: none;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
}

.btn-outline-professional:hover {
    background: rgba(255, 255, 255, 0.1);
    border-color: rgba(255, 255, 255, 0.5);
    color: white;
}

.hero-metrics {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 20px;
    padding: 2rem;
}

.metric-item {
    text-align: center;
}

.metric-number {
    font-size: 2.5rem;
    font-weight: 700;
    color: #3b82f6;
    margin-bottom: 0.5rem;
}

.metric-label {
    font-size: 0.9rem;
    color: #94a3b8;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Features Section - Wide Professional */
.features-section-wide {
    background: #f8fafc;
    padding: 120px 0;
    position: relative;
}

.section-title-professional {
    font-size: 3rem;
    font-weight: 700;
    color: #1e293b;
    margin-bottom: 1rem;
    text-align: center;
}

.section-subtitle-professional {
    font-size: 1.2rem;
    color: #64748b;
    text-align: center;
    max-width: 600px;
    margin: 0 auto;
    line-height: 1.6;
}

.features-grid {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 2rem;
}

.feature-card-wide {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 4rem;
    align-items: center;
    padding: 4rem 0;
    border-bottom: 1px solid #e2e8f0;
}

.feature-card-wide:last-child {
    border-bottom: none;
}

.feature-card-wide.reverse {
    grid-template-columns: 1fr 1fr;
}

.feature-content-left,
.feature-content-right {
    padding: 2rem 0;
}

.feature-icon-large {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 2rem;
    font-size: 2rem;
    color: white;
    box-shadow: 0 10px 25px rgba(59, 130, 246, 0.3);
}

.feature-content-left h3,
.feature-content-right h3 {
    font-size: 2.2rem;
    font-weight: 700;
    color: #1e293b;
    margin-bottom: 1.5rem;
    line-height: 1.3;
}

.feature-content-left p,
.feature-content-right p {
    font-size: 1.1rem;
    color: #475569;
    line-height: 1.7;
    margin-bottom: 2rem;
}

.feature-benefits-list {
    list-style: none;
    padding: 0;
}

.feature-benefits-list li {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
    font-size: 1rem;
    color: #64748b;
}

.feature-benefits-list i {
    color: #10b981;
    margin-right: 1rem;
    font-size: 1.1rem;
}

.feature-visual-right,
.feature-visual-left {
    display: flex;
    justify-content: center;
    align-items: center;
}

.visual-placeholder {
    width: 350px;
    height: 250px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 20px;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    color: white;
    font-size: 3rem;
    box-shadow: 0 20px 40px rgba(102, 126, 234, 0.3);
    position: relative;
    overflow: hidden;
}

.visual-placeholder::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(45deg, rgba(255, 255, 255, 0.1) 0%, transparent 100%);
}

.visual-placeholder span {
    font-size: 1.2rem;
    margin-top: 1rem;
    font-weight: 600;
}

.ai-visual {
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
}

.security-visual {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
}

.analytics-visual {
    background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
}

.additional-features {
    margin-top: 5rem;
    max-width: 1200px;
    margin-left: auto;
    margin-right: auto;
    padding: 0 2rem;
}

.feature-card-compact {
    background: white;
    padding: 2.5rem 2rem;
    border-radius: 15px;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
    text-align: center;
    height: 100%;
    transition: transform 0.3s ease;
}

.feature-card-compact:hover {
    transform: translateY(-5px);
}

.feature-icon-compact {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #f3f4f6, #e5e7eb);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    font-size: 1.5rem;
    color: #3b82f6;
}

.feature-card-compact h4 {
    font-size: 1.3rem;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 1rem;
}

.feature-card-compact p {
    color: #64748b;
    line-height: 1.6;
}

/* Trusted Companies Section */
.trusted-companies-section {
    background: white;
    padding: 4rem 0;
    border-bottom: 1px solid #e2e8f0;
}

.trusted-text {
    color: #64748b;
    font-size: 1rem;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-bottom: 2rem;
}

.companies-logos {
    display: flex;
    justify-content: center;
    align-items: center;
    flex-wrap: wrap;
    gap: 3rem;
    max-width: 1000px;
    margin: 0 auto;
}

.logo-item {
    font-size: 1.5rem;
    font-weight: 700;
    color: #94a3b8;
    transition: color 0.3s ease;
}

.logo-item:hover {
    color: #3b82f6;
}

/* Testimonials Section */
.testimonials-section {
    background: #f8fafc;
    padding: 120px 0;
}

.testimonials-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 2rem;
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
}

.testimonial-card {
    background: white;
    padding: 3rem 2.5rem;
    border-radius: 20px;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
    transition: transform 0.3s ease;
    position: relative;
}

.testimonial-card:hover {
    transform: translateY(-5px);
}

.testimonial-content {
    margin-bottom: 2rem;
}

.quote-icon {
    color: #3b82f6;
    font-size: 2rem;
    margin-bottom: 1rem;
}

.testimonial-text {
    font-size: 1.1rem;
    line-height: 1.7;
    color: #475569;
    margin: 0;
    font-style: italic;
}

.testimonial-author {
    display: flex;
    align-items: center;
}

.author-info h4 {
    font-size: 1.1rem;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 0.25rem;
}

.author-info p {
    color: #64748b;
    font-size: 0.95rem;
    margin: 0;
}

/* CTA Section Professional */
.cta-section-professional {
    background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
    padding: 120px 0;
    position: relative;
    color: white;
}

.cta-background-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at 50% 50%, rgba(59, 130, 246, 0.1) 0%, transparent 70%);
}

.cta-content-professional {
    position: relative;
    z-index: 2;
    text-align: center;
}

.cta-title-professional {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    color: white;
    line-height: 1.2;
}

.cta-subtitle-professional {
    font-size: 1.25rem;
    color: #cbd5e1;
    line-height: 1.7;
    margin-bottom: 3rem;
    max-width: 700px;
    margin-left: auto;
    margin-right: auto;
}

.cta-actions-professional {
    margin-bottom: 3rem;
}

.btn-xl {
    padding: 1.25rem 3rem;
    font-size: 1.2rem;
    font-weight: 600;
}

.btn-outline-professional-white {
    border: 2px solid rgba(255, 255, 255, 0.3);
    background: transparent;
    color: white;
    text-decoration: none;
    border-radius: 50px;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
}

.btn-outline-professional-white:hover {
    background: rgba(255, 255, 255, 0.1);
    border-color: rgba(255, 255, 255, 0.5);
    color: white;
}

.cta-guarantees {
    display: flex;
    justify-content: center;
    gap: 2rem;
    flex-wrap: wrap;
}

.guarantee-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #e2e8f0;
    font-size: 0.95rem;
}

.guarantee-item i {
    color: #10b981;
    font-size: 1.1rem;
}

/* Professional Responsive Design */
@media (max-width: 1200px) {
    .features-grid {
        padding: 0 3rem;
    }
    
    .feature-card-wide {
        gap: 3rem;
        padding: 3rem 0;
    }
    
    .hero-title-professional {
        font-size: 3.5rem;
    }
    
    .cta-title-professional {
        font-size: 3rem;
    }
}

@media (max-width: 768px) {
    .hero-section-wide {
        width: 100vw;
        margin-left: -50vw;
        margin-right: -50vw;
        left: 50%;
        right: 50%;
    }
    
    .hero-inner-content {
        padding: 0 1rem;
    }
    
    .hero-title-professional {
        font-size: 2.5rem;
        line-height: 1.2;
    }
    
    .hero-subtitle-professional {
        font-size: 1.1rem;
        margin-bottom: 2rem;
    }
    
    .hero-metrics {
        padding: 1.5rem;
    }
    
    .metric-number {
        font-size: 2rem;
    }
    
    .feature-card-wide {
        grid-template-columns: 1fr;
        gap: 2rem;
        padding: 3rem 0;
        text-align: center;
    }
    
    .feature-card-wide.reverse {
        grid-template-columns: 1fr;
    }
    
    .feature-card-wide.reverse .feature-visual-left {
        order: 1;
    }
    
    .feature-card-wide.reverse .feature-content-right {
        order: 2;
    }
    
    .features-grid {
        padding: 0 1rem;
    }
    
    .section-title-professional {
        font-size: 2.5rem;
    }
    
    .feature-content-left h3,
    .feature-content-right h3 {
        font-size: 1.8rem;
    }
    
    .visual-placeholder {
        width: 280px;
        height: 200px;
        font-size: 2rem;
    }
    
    .testimonials-grid {
        grid-template-columns: 1fr;
        padding: 0 1rem;
    }
    
    .companies-logos {
        gap: 2rem;
    }
    
    .logo-item {
        font-size: 1.2rem;
    }
    
    .cta-title-professional {
        font-size: 2.5rem;
    }
    
    .cta-subtitle-professional {
        font-size: 1.1rem;
    }
    
    .cta-guarantees {
        flex-direction: column;
        align-items: center;
        gap: 1rem;
    }
    
    .btn-xl {
        padding: 1rem 2rem;
        font-size: 1.1rem;
        width: 100%;
        max-width: 300px;
        margin-bottom: 1rem;
    }
    
    .hero-actions .btn-primary-professional,
    .hero-actions .btn-outline-professional {
        width: 100%;
        max-width: 300px;
        margin-bottom: 1rem;
    }
}

@media (max-width: 576px) {
    .hero-title-professional {
        font-size: 2rem;
    }
    
    .section-title-professional {
        font-size: 2rem;
    }
    
    .cta-title-professional {
        font-size: 2rem;
    }
    
    .visual-placeholder {
        width: 250px;
        height: 180px;
        font-size: 1.5rem;
    }
    
    .visual-placeholder span {
        font-size: 1rem;
    }
    
    .feature-content-left h3,
    .feature-content-right h3 {
        font-size: 1.5rem;
    }
    
    .testimonial-card {
        padding: 2rem 1.5rem;
    }
}

/* Remove all old unused styles to keep clean code */

/* How It Works Section */
.how-it-works-section {
    background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%);
    padding: 100px 0;
    position: relative;
}

.process-timeline {
    position: relative;
}

.step-card-modern {
    background: white;
    border-radius: 25px;
    padding: 2rem;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
    transition: all 0.4s ease;
    height: 100%;
    text-align: center;
    position: relative;
}

.step-card-modern:hover {
    transform: translateY(-10px);
    box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
}

.step-indicator {
    position: relative;
    margin-bottom: 1.5rem;
}

.step-number-modern {
    width: 70px;
    height: 70px;
    background: linear-gradient(135deg, var(--primary-color), #4fc3f7);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
    font-weight: bold;
    box-shadow: 0 10px 25px rgba(13, 110, 253, 0.3);
    transition: transform 0.3s ease;
    position: relative;
    z-index: 2;
}

.step-card-modern:hover .step-number-modern {
    transform: scale(1.1);
}

.step-connector {
    position: absolute;
    top: 35px;
    left: 50%;
    width: 100%;
    height: 2px;
    background: linear-gradient(90deg, transparent, #e3f2fd, transparent);
    z-index: 1;
}

.step-connector::after {
    content: '';
    position: absolute;
    right: -10px;
    top: -5px;
    width: 0;
    height: 0;
    border-left: 10px solid #e3f2fd;
    border-top: 6px solid transparent;
    border-bottom: 6px solid transparent;
}

.step-content h4 {
    font-size: 1.4rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: #2c3e50;
}

.step-icon {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, #e8f5e8, #c8e6c9);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
}

.step-icon i {
    font-size: 1.3rem;
    color: var(--success-color);
}

.step-time {
    background: linear-gradient(135deg, #fff3e0, #ffcc02);
    color: #f57c00;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 500;
    display: inline-block;
    margin-top: 1rem;
}

/* Statistics Section */
.stats-section {
    background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
    padding: 100px 0;
    color: white;
    position: relative;
    overflow: hidden;
}

.stats-section::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="75" cy="75" r="1" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
    opacity: 0.1;
}

.stat-card-modern {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 20px;
    padding: 2.5rem 2rem;
    text-align: center;
    transition: transform 0.3s ease;
}

.stat-card-modern:hover {
    transform: translateY(-10px);
}

.stat-icon {
    width: 80px;
    height: 80px;
    background: rgba(255, 255, 255, 0.15);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    font-size: 2rem;
    color: white;
}

.stat-number-large {
    font-size: 3rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
    background: linear-gradient(45deg, #ffffff, #e3f2fd);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.stat-label-modern {
    font-size: 1.1rem;
    opacity: 0.9;
    margin: 0;
}

/* CTA Section */
.cta-section {
    background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
    padding: 100px 0;
    position: relative;
}

.cta-content {
    max-width: 800px;
    margin: 0 auto;
}

.cta-title {
    font-size: 3rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    color: #2c3e50;
}

.cta-subtitle {
    font-size: 1.25rem;
    color: #6c757d;
    margin-bottom: 2.5rem;
    line-height: 1.6;
}

.cta-buttons {
    margin-bottom: 2rem;
}

.cta-features {
    display: flex;
    justify-content: center;
    gap: 2rem;
    flex-wrap: wrap;
}

.cta-feature {
    color: var(--success-color);
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.step-card {
    background: white;
    padding: 40px 30px;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    text-align: center;
    position: relative;
    height: 100%;
    transition: transform 0.3s ease;
}

.step-card:hover {
    transform: translateY(-5px);
}

.step-number {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    font-size: 2rem;
    font-weight: bold;
    box-shadow: 0 8px 16px rgba(13, 110, 253, 0.3);
    transition: transform 0.3s ease;
}

.step-card:hover .step-number {
    transform: scale(1.1);
}

.step-card h4 {
    margin-bottom: 1rem;
    font-weight: 600;
    color: #2c3e50;
}

.step-card p {
    color: #6c757d;
    line-height: 1.6;
}

.footer-section {
    background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
    color: white;
    padding: 40px 0;
    margin-top: 0;
}

.footer-section h5,
.footer-section h6 {
    color: #ffffff;
}

.footer-section a {
    transition: color 0.3s ease;
}

.footer-section a:hover {
    color: var(--primary-color) !important;
    text-decoration: none;
}

.social-links a {
    transition: all 0.3s ease;
}

.social-links a:hover {
    color: var(--primary-color) !important;
    transform: translateY(-2px);
}

/* Responsive Design */
@media (max-width: 768px) {
    .hero-section {
        min-height: auto;
        padding: 80px 0;
    }
    
    .hero-title {
        font-size: 2.5rem;
    }
    
    .hero-image-container {
        margin-top: 2rem;
    }
    
    .hero-buttons .btn {
        display: block;
        width: 100%;
        margin-bottom: 1rem;
    }
    
    .hero-buttons .btn:last-child {
        margin-bottom: 0;
    }
    
    .floating-card {
        position: static !important;
        margin: 1rem 0;
        transform: none !important;
        animation: none;
    }
    
    .hero-stats {
        margin-top: 2rem;
    }
    
    .feature-card,
    .step-card,
    .modern-card,
    .step-card-modern {
        margin-bottom: 2rem;
    }
    
    .step-connector {
        display: none;
    }
    
    .cta-title {
        font-size: 2rem;
    }
    
    .highlight-title {
        font-size: 2rem;
    }
    
    .security-visual {
        margin-top: 2rem;
    }
    
    .cta-features {
        flex-direction: column;
        align-items: center;
        gap: 1rem;
    }
    
    .stat-number-large {
        font-size: 2.5rem;
    }
}

@media (max-width: 576px) {
    .hero-title {
        font-size: 2rem;
    }
    
    .section-title {
        font-size: 2rem;
    }
}
</style>

<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script>
    // Initialize AOS
    AOS.init({
        duration: 800,
        easing: 'ease-in-out',
        once: true,
        offset: 100
    });

    // Smooth scrolling for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Counter animation for statistics
    function animateNumbers() {
        const counters = document.querySelectorAll('[data-count]');
        const options = {
            threshold: 0.7
        };

        const observer = new IntersectionObserver(function(entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const counter = entry.target;
                    const target = parseInt(counter.getAttribute('data-count'));
                    const increment = target / 100;
                    let current = 0;

                    const updateCounter = () => {
                        if (current < target) {
                            current += increment;
                            counter.textContent = Math.ceil(current) + (counter.textContent.includes('+') ? '+' : counter.textContent.includes('%') ? '%' : '');
                            setTimeout(updateCounter, 20);
                        } else {
                            counter.textContent = target + (counter.textContent.includes('+') ? '+' : counter.textContent.includes('%') ? '%' : '');
                        }
                    };
                    updateCounter();
                    observer.unobserve(counter);
                }
            });
        }, options);

        counters.forEach(counter => observer.observe(counter));
    }

    // Initialize counter animation when page loads
    window.addEventListener('load', animateNumbers);

    // Add parallax effect to hero shapes
    window.addEventListener('scroll', () => {
        const scrolled = window.pageYOffset;
        const shapes = document.querySelectorAll('.shape');
        
        shapes.forEach((shape, index) => {
            const speed = 0.5 + (index * 0.1);
            shape.style.transform = `translateY(${scrolled * speed}px)`;
        });
    });
</script>

<?php include 'includes/footer.php'; ?>