<?php
/**
 * Test Session Invitation Email Template
 * This template generates a comprehensive HTML email for test invitations
 */

function generateTestInvitationEmail($candidateData, $sessionData, $jobRoleData) {
    $html = '
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Invitation - OACSOFT CBT</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: bold;
        }
        .header p {
            margin: 10px 0 0 0;
            font-size: 16px;
            opacity: 0.9;
        }
        .content {
            padding: 30px;
        }
        .welcome {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 25px;
            border-left: 4px solid #667eea;
        }
        .test-details {
            background-color: #fff;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #f1f3f4;
        }
        .detail-row:last-child {
            border-bottom: none;
        }
        .detail-label {
            font-weight: bold;
            color: #495057;
        }
        .detail-value {
            color: #6c757d;
        }
        .access-code {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
            margin: 20px 0;
            font-size: 18px;
            font-weight: bold;
            letter-spacing: 2px;
        }
        .instructions {
            background-color: #e7f3ff;
            border: 1px solid #b3d9ff;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .instructions h3 {
            color: #0056b3;
            margin-top: 0;
        }
        .step {
            margin: 10px 0;
            padding-left: 20px;
            position: relative;
        }
        .step::before {
            content: counter(step-counter);
            counter-increment: step-counter;
            position: absolute;
            left: 0;
            top: 0;
            background: #667eea;
            color: white;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: bold;
        }
        .steps {
            counter-reset: step-counter;
        }
        .terms {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .terms h3 {
            color: #856404;
            margin-top: 0;
        }
        .terms ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        .terms li {
            margin: 5px 0;
        }
        .cta-button {
            display: inline-block;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 8px;
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
            transition: transform 0.2s;
        }
        .cta-button:hover {
            transform: translateY(-2px);
            text-decoration: none;
            color: white;
        }
        .footer {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            border-top: 1px solid #e9ecef;
        }
        .footer p {
            margin: 5px 0;
            color: #6c757d;
            font-size: 14px;
        }
        .highlight {
            background-color: #fff3cd;
            padding: 2px 6px;
            border-radius: 4px;
            font-weight: bold;
        }
        .warning {
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
        }
        @media (max-width: 600px) {
            .container {
                margin: 0;
                box-shadow: none;
            }
            .content {
                padding: 20px;
            }
            .detail-row {
                flex-direction: column;
            }
            .detail-label {
                margin-bottom: 5px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎯 Test Invitation</h1>
            <p>OACSOFT TECHNOLOGIES - Computer Based Test</p>
        </div>
        
        <div class="content">
            <div class="welcome">
                <h2>Hello ' . htmlspecialchars($candidateData['full_name']) . '! 👋</h2>
                <p>You have been scheduled for a computer-based test. Please find all the details below and follow the instructions carefully.</p>
            </div>
            
            <div class="test-details">
                <h3>📋 Test Session Details</h3>
                <div class="detail-row">
                    <span class="detail-label">Job Role:</span>
                    <span class="detail-value">' . htmlspecialchars($jobRoleData['role_name']) . '</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Scheduled Date & Time:</span>
                    <span class="detail-value">' . date('l, F j, Y \a\t g:i A', strtotime($sessionData['scheduled_time'])) . '</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Duration:</span>
                    <span class="detail-value">' . $sessionData['duration_minutes'] . ' minutes</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Total Questions:</span>
                    <span class="detail-value">' . $sessionData['total_questions'] . ' questions</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Total Marks:</span>
                    <span class="detail-value">' . $sessionData['total_marks'] . ' marks</span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Passing Score:</span>
                    <span class="detail-value">60% (Minimum required)</span>
                </div>
            </div>
            
            <div class="access-code">
                🔑 Your Access Code: ' . $sessionData['access_code'] . '
            </div>
            
            <div class="warning">
                <strong>⚠️ Important:</strong> Keep this access code secure and do not share it with anyone. You will need this code to start your test.
            </div>
            
            <div class="instructions">
                <h3>📝 How to Take Your Test</h3>
                <div class="steps">
                    <div class="step">Visit the test portal at: <strong>' . SITE_URL . '</strong></div>
                    <div class="step">Click on "Login" and enter your registered email and password</div>
                    <div class="step">Go to your dashboard and click "Start Test"</div>
                    <div class="step">Enter your access code: <span class="highlight">' . $sessionData['access_code'] . '</span></div>
                    <div class="step">Read all instructions carefully before starting</div>
                    <div class="step">Answer all questions within the time limit</div>
                    <div class="step">Submit your test before time expires</div>
                </div>
            </div>
            
            <div class="terms">
                <h3>📜 Terms and Conditions</h3>
                <ul>
                    <li><strong>Punctuality:</strong> Please join at least 10 minutes before the scheduled time</li>
                    <li><strong>Technical Requirements:</strong> Ensure stable internet connection and updated browser</li>
                    <li><strong>Environment:</strong> Take the test in a quiet, well-lit environment</li>
                    <li><strong>Fair Play:</strong> No external help, books, or resources are allowed during the test</li>
                    <li><strong>Single Attempt:</strong> You get only one attempt to complete the test</li>
                    <li><strong>Auto-Submit:</strong> Test will be automatically submitted when time expires</li>
                    <li><strong>Technical Issues:</strong> Contact support immediately if you face any technical problems</li>
                    <li><strong>Results:</strong> Results will be communicated within 2-3 business days</li>
                    <li><strong>Validity:</strong> This access code is valid only for the scheduled date and time</li>
                    <li><strong>Browser:</strong> Use Chrome, Firefox, or Edge for best experience</li>
                </ul>
            </div>
            
            <div style="text-align: center;">
                <a href="' . SITE_URL . 'login.php" class="cta-button">
                    🚀 Access Test Portal
                </a>
            </div>
            
            <div class="warning">
                <strong>📞 Need Help?</strong><br>
                If you have any questions or face technical difficulties, please contact our support team:<br>
                📧 Email: ' . FROM_EMAIL . '<br>
                📱 Phone: +1 (555) 123-4567<br>
                🕒 Support Hours: Monday to Friday, 9:00 AM - 6:00 PM
            </div>
        </div>
        
        <div class="footer">
            <p><strong>OACSOFT TECHNOLOGIES</strong></p>
            <p>Computer Based Testing System</p>
            <p>This is an automated email. Please do not reply to this email.</p>
            <p>© ' . date('Y') . ' OACSOFT Technologies. All rights reserved.</p>
        </div>
    </div>
</body>
</html>';
    
    return $html;
}

/**
 * Generate plain text version of the invitation email
 */
function generateTestInvitationTextEmail($candidateData, $sessionData, $jobRoleData) {
    $text = "OACSOFT TECHNOLOGIES - Test Invitation\n";
    $text .= "=====================================\n\n";
    $text .= "Hello " . $candidateData['full_name'] . "!\n\n";
    $text .= "You have been scheduled for a computer-based test.\n\n";
    
    $text .= "TEST DETAILS:\n";
    $text .= "-------------\n";
    $text .= "Job Role: " . $jobRoleData['role_name'] . "\n";
    $text .= "Date & Time: " . date('l, F j, Y \a\t g:i A', strtotime($sessionData['scheduled_time'])) . "\n";
    $text .= "Duration: " . $sessionData['duration_minutes'] . " minutes\n";
    $text .= "Total Questions: " . $sessionData['total_questions'] . "\n";
    $text .= "Total Marks: " . $sessionData['total_marks'] . "\n";
    $text .= "Passing Score: 60% (Minimum required)\n\n";
    
    $text .= "ACCESS CODE: " . $sessionData['access_code'] . "\n";
    $text .= "(Keep this code secure and do not share)\n\n";
    
    $text .= "HOW TO TAKE YOUR TEST:\n";
    $text .= "----------------------\n";
    $text .= "1. Visit: " . SITE_URL . "\n";
    $text .= "2. Login with your registered email and password\n";
    $text .= "3. Go to dashboard and click 'Start Test'\n";
    $text .= "4. Enter access code: " . $sessionData['access_code'] . "\n";
    $text .= "5. Read instructions carefully\n";
    $text .= "6. Answer all questions within time limit\n";
    $text .= "7. Submit before time expires\n\n";
    
    $text .= "IMPORTANT TERMS:\n";
    $text .= "----------------\n";
    $text .= "- Join 10 minutes before scheduled time\n";
    $text .= "- Ensure stable internet and updated browser\n";
    $text .= "- Take test in quiet environment\n";
    $text .= "- No external help allowed\n";
    $text .= "- Single attempt only\n";
    $text .= "- Auto-submit when time expires\n";
    $text .= "- Results within 2-3 business days\n\n";
    
    $text .= "SUPPORT CONTACT:\n";
    $text .= "----------------\n";
    $text .= "Email: " . FROM_EMAIL . "\n";
    $text .= "Phone: +1 (555) 123-4567\n";
    $text .= "Hours: Monday-Friday, 9 AM - 6 PM\n\n";
    
    $text .= "Best of luck with your test!\n\n";
    $text .= "OACSOFT Technologies\n";
    $text .= "Computer Based Testing System\n";
    
    return $text;
}
?>