<?php
// Mail helper class for OACSOFT CBT System using PHPMailer
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../config/database.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class MailHelper {
    private $host;
    private $username;
    private $password;
    private $port;
    private $from_email;
    private $from_name;
    private $reply_to_email;
    private $reply_to_name;
    
    public function __construct() {
        $this->host = EMAIL_HOST;
        $this->username = EMAIL_USERNAME;
        $this->password = EMAIL_PASSWORD;
        $this->port = EMAIL_PORT;
        $this->from_email = FROM_EMAIL;
        $this->from_name = FROM_NAME;
        $this->reply_to_email = REPLY_TO_EMAIL;
        $this->reply_to_name = REPLY_TO_NAME;
    }
    
    public function sendEmail($to_email, $to_name, $subject, $message, $is_html = true) {
        try {
            $mail = new PHPMailer(true);
            
            // Server settings
            $mail->isSMTP();
            $mail->Host = $this->host;
            $mail->SMTPAuth = true;
            $mail->Username = $this->username;
            $mail->Password = $this->password;
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = $this->port;
            
            // Recipients
            $mail->setFrom($this->from_email, $this->from_name);
            $mail->addAddress($to_email, $to_name);
            $mail->addReplyTo($this->reply_to_email, $this->reply_to_name);
            
            // Content
            $mail->isHTML($is_html);
            $mail->Subject = $subject;
            $mail->Body = $message;
            
            if (!$is_html) {
                $mail->AltBody = $message;
            }
            
            $mail->send();
            return ['success' => true, 'message' => 'Email sent successfully'];
            
        } catch (Exception $e) {
            return ['success' => false, 'message' => 'Email could not be sent. Error: ' . $mail->ErrorInfo];
        }
    }
    
    public function sendTestEmail($to_email, $to_name = 'Test User') {
        $subject = 'Test Email from OACSOFT CBT System';
        $message = '
        <html>
        <head>
            <title>Test Email</title>
        </head>
        <body>
            <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
                <h2 style="color: #0d6efd;">Test Email Successful!</h2>
                <p>Hello ' . htmlspecialchars($to_name) . ',</p>
                <p>This is a test email from the OACSOFT CBT System. If you received this email, your email configuration is working correctly.</p>
                <div style="background-color: #f8f9fa; padding: 15px; border-radius: 5px; margin: 20px 0;">
                    <h4>Email Configuration Details:</h4>
                    <ul>
                        <li><strong>SMTP Host:</strong> ' . $this->host . '</li>
                        <li><strong>SMTP Port:</strong> ' . $this->port . '</li>
                        <li><strong>From Email:</strong> ' . $this->from_email . '</li>
                        <li><strong>From Name:</strong> ' . $this->from_name . '</li>
                    </ul>
                </div>
                <p>Best regards,<br>OACSOFT Technologies Team</p>
            </div>
        </body>
        </html>
        ';
        
        return $this->sendEmail($to_email, $to_name, $subject, $message, true);
    }
    
    public function sendInvitationEmail($to_email, $to_name, $access_code, $test_session_details) {
        $subject = 'Invitation to Computer Based Test - ' . $test_session_details['title'];
        
        // Load the email template
        ob_start();
        include __DIR__ . '/test-invitation-template.php';
        $message = ob_get_clean();
        
        return $this->sendEmail($to_email, $to_name, $subject, $message, true);
    }
    
    public function sendResultEmail($to_email, $to_name, $result_details) {
        $subject = 'Your Test Results - ' . $result_details['test_title'];
        
        $message = '
        <html>
        <head>
            <title>Test Results</title>
        </head>
        <body>
            <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
                <h2 style="color: #0d6efd;">Test Results</h2>
                <p>Dear ' . htmlspecialchars($to_name) . ',</p>
                <p>Your test results for "' . htmlspecialchars($result_details['test_title']) . '" are now available.</p>
                
                <div style="background-color: #f8f9fa; padding: 20px; border-radius: 5px; margin: 20px 0;">
                    <h3>Results Summary:</h3>
                    <table style="width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Score:</strong></td>
                            <td style="padding: 8px; border-bottom: 1px solid #ddd;">' . $result_details['score'] . '%</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Correct Answers:</strong></td>
                            <td style="padding: 8px; border-bottom: 1px solid #ddd;">' . $result_details['correct_answers'] . ' out of ' . $result_details['total_questions'] . '</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px; border-bottom: 1px solid #ddd;"><strong>Test Date:</strong></td>
                            <td style="padding: 8px; border-bottom: 1px solid #ddd;">' . date('F j, Y g:i A', strtotime($result_details['completed_at'])) . '</td>
                        </tr>
                    </table>
                </div>
                
                <p>Thank you for participating in our assessment.</p>
                <p>Best regards,<br>OACSOFT Technologies Team</p>
            </div>
        </body>
        </html>
        ';
        
        return $this->sendEmail($to_email, $to_name, $subject, $message, true);
    }
    
    public function testConnection() {
        try {
            $mail = new PHPMailer(true);
            
            // Server settings
            $mail->isSMTP();
            $mail->Host = $this->host;
            $mail->SMTPAuth = true;
            $mail->Username = $this->username;
            $mail->Password = $this->password;
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = $this->port;
            
            // Test SMTP connection
            $mail->SMTPDebug = 0; // Disable debug output
            $result = $mail->smtpConnect();
            $mail->smtpClose();
            
            if ($result) {
                return ['success' => true, 'message' => 'SMTP connection successful'];
            } else {
                return ['success' => false, 'message' => 'SMTP connection failed'];
            }
            
        } catch (Exception $e) {
            return ['success' => false, 'message' => 'Connection test failed: ' . $e->getMessage()];
        }
    }
}
?>