<?php
    // Only close container for non-landing pages
    $current_page = basename($_SERVER['PHP_SELF']);
    if ($current_page !== 'index.php'): ?>
    </div>
    <?php endif; ?>

    <!-- Spacer div to ensure proper spacing -->
    <div class="mt-5 mb-4"></div>

    <?php
    // Only show footer on non-admin pages
    $current_page = basename($_SERVER['PHP_SELF']);
    $is_admin_page = strpos($_SERVER['REQUEST_URI'], '/admin/') !== false;
    if (!$is_admin_page): ?>
    <footer class="bg-dark text-light py-4 mt-auto">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-0">&copy; <?php echo date('Y'); ?> OACSOFT TECHNOLOGIES LTD. All Rights Reserved.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">Built with <i class="fas fa-heart text-danger"></i> for Modern Recruitment</p>
                </div>
            </div>
        </div>
    </footer>
    <?php endif; ?>

    <!-- SweetAlert2 JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo SITE_URL; ?>assets/js/main.js"></script>
    
    <?php if(isset($_SESSION['success_message'])): ?>
        <div class="toast-container position-fixed bottom-0 end-0 p-3">
            <div class="toast show" role="alert">
                <div class="toast-header bg-success text-white">
                    <strong class="me-auto">Success</strong>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
                </div>
                <div class="toast-body">
                    <?php echo $_SESSION['success_message']; ?>
                </div>
            </div>
        </div>
        <?php unset($_SESSION['success_message']); ?>
    <?php endif; ?>

    <?php if(isset($_SESSION['error_message'])): ?>
        <div class="toast-container position-fixed bottom-0 end-0 p-3">
            <div class="toast show" role="alert">
                <div class="toast-header bg-danger text-white">
                    <strong class="me-auto">Error</strong>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
                </div>
                <div class="toast-body">
                    <?php echo $_SESSION['error_message']; ?>
                </div>
            </div>
        </div>
        <?php unset($_SESSION['error_message']); ?>
    <?php endif; ?>
</body>
</html>