<?php
// Database configuration for OACSOFT CBT System
class Database {
    private $host;
    private $db_name;
    private $username;
    private $password;
    private $connection;
    
    public function __construct() {
        $this->host = 'localhost';
        $this->db_name = 'oacsoft_cbt';
        $this->username = 'root'; // Change this to your MySQL username
        $this->password = ''; // Change this to your MySQL password
    }
    
    public function connect() {
        $this->connection = null;
        
        try {
            $this->connection = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->db_name,
                $this->username,
                $this->password,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false,
                ]
            );
        } catch(PDOException $e) {
            // Log error instead of echoing to prevent headers already sent error
            error_log("Database Connection error: " . $e->getMessage());
        }
        
        return $this->connection;
    }
    
    public function getConnection() {
        return $this->connection;
    }
}

// Helper function to sanitize input
define('SITE_URL', 'http://localhost/cbt/');

define('EMAIL_HOST', 'mail.cloudserve.com.ng');
define('EMAIL_USERNAME', 'obinna.prince@cloudserve.com.ng');
define('EMAIL_PASSWORD', 'Obidike@321#');
define('EMAIL_PORT', 587);

// Email Settings
define('FROM_EMAIL', 'obinna.prince@cloudserve.com.ng');    // Sender email
define('FROM_NAME', 'OacSoft CBT For Employees');     // Sender name
define('REPLY_TO_EMAIL', 'obinna.prince@cloudserve.com.ng'); // Reply-to email
define('REPLY_TO_NAME', 'OacSoft CBT For Employees');     // Reply-to name

function sanitize($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

function redirect($url) {
    header("Location: " . SITE_URL . $url);
    exit();
}

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function isAdmin() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
}

function generateAccessCode() {
    return strtoupper(substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 8));
}

function isCandidate() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'candidate';
}

function sanitizeInput($data) {
    return sanitize($data);
}
?>