<?php 
include '../includes/header.php'; 

if (!isCandidate()) {
    redirect('../login.php');
}

$user_id = $_SESSION['user_id'];

// Fetch test history for the candidate
$stmt = $conn->prepare("SELECT ts.*, jr.role_name, tr.score, tr.total_questions, tr.percentage, tr.completed_at as result_completed_at
                       FROM test_sessions ts
                       JOIN job_roles jr ON ts.job_role_id = jr.id
                       LEFT JOIN test_results tr ON ts.id = tr.session_id
                       WHERE ts.user_id = ?
                       ORDER BY ts.created_at DESC");
$stmt->execute([$user_id]);
$test_history = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2>
            <i class="fas fa-history me-2"></i>
            Test History
        </h2>
        <p class="text-muted mb-0">View your past test sessions and results</p>
    </div>
    <a href="dashboard.php" class="btn btn-outline-primary">
        <i class="fas fa-arrow-left me-2"></i>
        Back to Dashboard
    </a>
</div>

<?php if (count($test_history) > 0): ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-list me-2"></i>
                        Your Test Sessions
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Job Role</th>
                                    <th>Access Code</th>
                                    <th>Scheduled Time</th>
                                    <th>Duration</th>
                                    <th>Status</th>
                                    <th>Score</th>
                                    <th>Percentage</th>
                                    <th>Completed</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($test_history as $session): 
                                    $status_class = '';
                                    $status_text = ucfirst($session['status']);
                                    
                                    switch($session['status']) {
                                        case 'scheduled':
                                            $status_class = 'bg-info';
                                            break;
                                        case 'in_progress':
                                            $status_class = 'bg-warning';
                                            break;
                                        case 'completed':
                                            $status_class = 'bg-success';
                                            break;
                                        case 'expired':
                                            $status_class = 'bg-danger';
                                            break;
                                        default:
                                            $status_class = 'bg-secondary';
                                    }
                                    
                                    $percentage = $session['percentage'] ? round($session['percentage']) : 0;
                                    $passed = $percentage >= 70;
                                ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo htmlspecialchars($session['role_name']); ?></strong>
                                        </td>
                                        <td>
                                            <code><?php echo htmlspecialchars($session['access_code']); ?></code>
                                        </td>
                                        <td>
                                            <?php if ($session['scheduled_time']): ?>
                                                <?php echo date('M j, Y H:i', strtotime($session['scheduled_time'])); ?>
                                            <?php else: ?>
                                                <span class="text-muted">Not scheduled</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo $session['duration_minutes']; ?> minutes
                                        </td>
                                        <td>
                                            <span class="badge <?php echo $status_class; ?>">
                                                <?php echo $status_text; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if ($session['score'] !== null): ?>
                                                <?php echo $session['score']; ?>/<?php echo $session['total_questions']; ?>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($session['percentage'] !== null): ?>
                                                <span class="badge bg-<?php echo $passed ? 'success' : 'danger'; ?>">
                                                    <?php echo $percentage; ?>%
                                                </span>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($session['result_completed_at']): ?>
                                                <?php echo date('M j, Y H:i', strtotime($session['result_completed_at'])); ?>
                                            <?php else: ?>
                                                <span class="text-muted">Not completed</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($session['status'] === 'completed' && $session['score'] !== null): ?>
                                                <a href="result.php?id=<?php echo $session['id']; ?>" 
                                                   class="btn btn-sm btn-outline-primary" 
                                                   title="View Results">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            <?php elseif ($session['status'] === 'scheduled' || $session['status'] === 'in_progress'): ?>
                                                <a href="test.php?session_id=<?php echo $session['id']; ?>" 
                                                   class="btn btn-sm btn-outline-success" 
                                                   title="Continue Test">
                                                    <i class="fas fa-play"></i>
                                                </a>
                                            <?php else: ?>
                                                <span class="text-muted">No actions</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Summary Statistics -->
    <div class="row mt-4">
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h4 class="text-primary"><?php echo count($test_history); ?></h4>
                    <p class="text-muted mb-0">Total Tests</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <?php 
                    $completed_tests = array_filter($test_history, function($session) {
                        return $session['status'] === 'completed';
                    });
                    ?>
                    <h4 class="text-success"><?php echo count($completed_tests); ?></h4>
                    <p class="text-muted mb-0">Completed</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <?php 
                    $passed_tests = array_filter($completed_tests, function($session) {
                        return $session['percentage'] && $session['percentage'] >= 70;
                    });
                    ?>
                    <h4 class="text-info"><?php echo count($passed_tests); ?></h4>
                    <p class="text-muted mb-0">Passed</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <?php 
                    $avg_percentage = 0;
                    if (count($completed_tests) > 0) {
                        $total_percentage = array_sum(array_column($completed_tests, 'percentage'));
                        $avg_percentage = round($total_percentage / count($completed_tests));
                    }
                    ?>
                    <h4 class="text-warning"><?php echo $avg_percentage; ?>%</h4>
                    <p class="text-muted mb-0">Average Score</p>
                </div>
            </div>
        </div>
    </div>
    
<?php else: ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body text-center py-5">
                    <i class="fas fa-history fa-4x text-muted mb-4"></i>
                    <h4 class="text-muted">No Test History</h4>
                    <p class="text-muted mb-4">You haven't taken any tests yet. Start your first test from the dashboard.</p>
                    <a href="dashboard.php" class="btn btn-primary">
                        <i class="fas fa-tachometer-alt me-2"></i>
                        Go to Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php include '../includes/footer.php'; ?>