<?php
session_start();
require_once '../config/database.php';

// Check if user is logged in and is a candidate
if (!isLoggedIn() || !isCandidate()) {
    $_SESSION['error'] = 'Please login to access this page';
    redirect('../login.php');
}

// Handle test start request
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['access_code'])) {
    $access_code = sanitizeInput($_POST['access_code']);
    $user_id = $_SESSION['user_id'];

    // Validate access code
    $stmt = $conn->prepare("SELECT ts.*, jr.role_name, jr.id as job_role_id
                          FROM test_sessions ts
                          JOIN job_roles jr ON ts.job_role_id = jr.id
                          WHERE ts.access_code = ? AND ts.user_id = ? AND ts.status = 'scheduled'");
    $stmt->execute([$access_code, $user_id]);
    $test_session = $stmt->fetch();

    if (!$test_session) {
        $_SESSION['error'] = 'Invalid access code or test session not found';
        header('Location: dashboard.php');
        exit;
    }

    // Check if test has already been started/completed
    $stmt = $conn->prepare("SELECT * FROM test_results WHERE session_id = ?");
    $stmt->execute([$test_session['id']]);
    $existing_result = $stmt->fetch();

    if ($existing_result) {
        $_SESSION['error'] = 'You have already completed this test';
        header('Location: dashboard.php');
        exit;
    }

    // Check if scheduled time has passed
    $scheduled_time = strtotime($test_session['scheduled_time']);
    $current_time = time();
    
    if ($current_time < $scheduled_time) {
        $_SESSION['error'] = 'Test has not started yet. Scheduled time: ' . date('Y-m-d H:i', $scheduled_time);
        header('Location: dashboard.php');
        exit;
    }

    // Check if test has expired
    $duration_seconds = $test_session['duration_minutes'] * 60;
    $end_time = $scheduled_time + $duration_seconds;
    
    if ($current_time > $end_time) {
        $_SESSION['error'] = 'Test has expired';
        header('Location: dashboard.php');
        exit;
    }

    // Set up test session variables
    $_SESSION['test_session'] = $test_session;
    $_SESSION['test_start_time'] = time();
    $_SESSION['test_end_time'] = $end_time;

    // Redirect to test page
    header('Location: test.php');
    exit;
} else {
    $_SESSION['error'] = 'Invalid request';
    header('Location: dashboard.php');
    exit;
}
?>