<?php
session_start();
require_once '../config/database.php';

// Check if user is logged in and is a candidate
if (!isLoggedIn() || !isCandidate()) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Check if required data is provided
if (!isset($_POST['result_id']) || !isset($_POST['question_id']) || !isset($_POST['answer'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing required data']);
    exit;
}

$result_id = (int)$_POST['result_id'];
$question_id = (int)$_POST['question_id'];
$answer = sanitizeInput($_POST['answer']);
$user_id = $_SESSION['user_id'];

// Verify the result belongs to the session and is not completed
$stmt = $conn->prepare("SELECT tr.*, ts.job_role_id FROM test_results tr JOIN test_sessions ts ON tr.session_id = ts.id WHERE tr.id = ? AND tr.completed_at IS NULL");
$stmt->execute([$result_id]);
$result = $stmt->fetch();

if (!$result) {
    http_response_code(403);
    echo json_encode(['error' => 'Invalid test session']);
    exit;
}

// Check if question exists and belongs to the job role
$stmt = $conn->prepare("SELECT * FROM questions WHERE id = ? AND job_role_id = ?");
$stmt->execute([$question_id, $result['job_role_id']]);
$question = $stmt->fetch();

if (!$question) {
    http_response_code(404);
    echo json_encode(['error' => 'Invalid question']);
    exit;
}

// Save or update the answer
$stmt = $conn->prepare("SELECT tr.session_id FROM test_results tr WHERE tr.id = ?");
$stmt->execute([$result_id]);
$session_data = $stmt->fetch();
$session_id = $session_data['session_id'];

$stmt = $conn->prepare("SELECT * FROM user_answers WHERE session_id = ? AND question_id = ?");
$stmt->execute([$session_id, $question_id]);
$existing = $stmt->fetch();

if ($existing) {
    // Update existing answer
    $stmt = $conn->prepare("UPDATE user_answers SET selected_answer = ? WHERE session_id = ? AND question_id = ?");
    $stmt->execute([$answer, $session_id, $question_id]);
} else {
    // Insert new answer
    $stmt = $conn->prepare("INSERT INTO user_answers (session_id, question_id, selected_answer, is_correct) VALUES (?, ?, ?, NULL)");
    $stmt->execute([$session_id, $question_id, $answer]);
}

echo json_encode(['success' => true]);
?>