<?php 
include '../includes/header.php'; 

if (!isCandidate()) {
    redirect('../login.php');
}

$user_id = $_SESSION['user_id'];

// Get session ID from URL
$session_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if (!$session_id) {
    $_SESSION['error_message'] = "Invalid session ID";
    header('Location: dashboard.php');
    exit;
}

// Fetch result details
$stmt = $conn->prepare("SELECT r.*, ts.*, jr.role_name, u.full_name, u.email
                       FROM test_results r 
                       JOIN test_sessions ts ON r.session_id = ts.id
                       JOIN job_roles jr ON ts.job_role_id = jr.id
                       JOIN users u ON ts.user_id = u.id
                       WHERE ts.id = ? AND ts.user_id = ?");
$stmt->execute([$session_id, $user_id]);
$result = $stmt->fetch();

if (!$result) {
    $_SESSION['error_message'] = "Result not found or access denied";
    header('Location: dashboard.php');
    exit;
}

// Fetch detailed answers
$stmt = $conn->prepare("SELECT ua.*, q.question, q.option_a, q.option_b, q.option_c, q.option_d, q.correct_answer, q.marks
                       FROM user_answers ua
                       JOIN questions q ON ua.question_id = q.id
                       WHERE ua.session_id = ?
                       ORDER BY q.id");
$stmt->execute([$result['session_id']]);
$answers = $stmt->fetchAll();

$percentage = round($result['percentage']);
$passed = $percentage >= 70; // 70% passing threshold
$pass_status = $passed ? 'Passed' : 'Failed';
$status_class = $passed ? 'success' : 'danger';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2>
            <i class="fas fa-chart-bar me-2"></i>
            Test Results
        </h2>
        <p class="text-muted mb-0">Review your performance in detail</p>
    </div>
    <div>
        <a href="dashboard.php" class="btn btn-primary">
            <i class="fas fa-arrow-left me-1"></i>Back to Dashboard
        </a>
    </div>
</div>

<!-- Result Summary Card -->
<div class="row mb-4">
    <div class="col-lg-8 mx-auto">
        <div class="card result-summary">
            <div class="card-header text-center">
                <h4 class="mb-0"><?php echo htmlspecialchars($result['role_name']); ?> Test Results</h4>
            </div>
            <div class="card-body text-center">
                <div class="row">
                    <div class="col-md-4">
                        <div class="result-stat">
                            <h3 class="text-primary"><?php echo $result['score']; ?></h3>
                            <p class="text-muted">Score</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="result-stat">
                            <h3 class="text-info"><?php echo $result['total_questions']; ?></h3>
                            <p class="text-muted">Total Questions</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="result-stat">
                            <h3 class="text-<?php echo $status_class; ?>"><?php echo $percentage; ?>%</h3>
                            <p class="text-muted">Percentage</p>
                        </div>
                    </div>
                </div>
                
                <div class="mt-4">
                    <span class="badge bg-<?php echo $status_class; ?> fs-5">
                        <i class="fas fa-<?php echo $passed ? 'check' : 'times'; ?> me-2"></i>
                        <?php echo $pass_status; ?>
                    </span>
                </div>
                
                <div class="mt-3 text-muted">
                    <small>
                        Completed on: <?php echo date('M j, Y H:i', strtotime($result['completed_at'])); ?> | 
                        Duration: <?php echo $result['duration_minutes']; ?> minutes
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Detailed Results -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-list-alt me-2"></i>
                    Detailed Answer Review
                </h5>
            </div>
            <div class="card-body">
                <?php if (count($answers) > 0): ?>
                    <div class="accordion" id="answerAccordion">
                        <?php foreach ($answers as $index => $answer): 
                            $is_correct = $answer['is_correct'];
                            $question_number = $index + 1;
                        ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="heading<?php echo $question_number; ?>">
                                    <button class="accordion-button <?php echo $is_correct ? 'text-success' : 'text-danger'; ?>" 
                                            type="button" 
                                            data-bs-toggle="collapse" 
                                            data-bs-target="#collapse<?php echo $question_number; ?>"
                                            aria-expanded="false" 
                                            aria-controls="collapse<?php echo $question_number; ?>">
                                        <div class="d-flex justify-content-between w-100">
                                            <span>
                                                <i class="fas fa-<?php echo $is_correct ? 'check-circle' : 'times-circle'; ?> me-2"></i>
                                                Question <?php echo $question_number; ?>
                                            </span>
                                            <span class="badge bg-<?php echo $is_correct ? 'success' : 'danger'; ?>">
                                <?php echo $is_correct ? $answer['marks'] : 0; ?>/<?php echo $answer['marks']; ?>
                                            </span>
                                        </div>
                                    </button>
                                </h2>
                                <div id="collapse<?php echo $question_number; ?>" 
                                     class="accordion-collapse collapse" 
                                     aria-labelledby="heading<?php echo $question_number; ?>" 
                                     data-bs-parent="#answerAccordion">
                                    <div class="accordion-body">
                                        <div class="mb-3">
                                            <strong>Question:</strong>
                                            <p><?php echo htmlspecialchars($answer['question']); ?></p>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <strong>Your Answer:</strong>
                                                <div class="p-2 border rounded <?php echo $is_correct ? 'border-success bg-success bg-opacity-10' : 'border-danger bg-danger bg-opacity-10'; ?>">
                                                    <?php 
                                                    $user_answer = $answer['selected_answer'];
                                                    $options = [
                                                        'A' => $answer['option_a'],
                                                        'B' => $answer['option_b'],
                                                        'C' => $answer['option_c'],
                                                        'D' => $answer['option_d']
                                                    ];
                                                    
                                                    if ($user_answer && isset($options[$user_answer])) {
                                                        echo "<strong>{$user_answer}.</strong> " . htmlspecialchars($options[$user_answer]);
                                                    } else {
                                                        echo "<em>Not answered</em>";
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6">
                                                <strong>Correct Answer:</strong>
                                                <div class="p-2 border rounded border-success bg-success bg-opacity-10">
                                                    <strong><?php echo $answer['correct_answer']; ?>.</strong> 
                                                    <?php echo htmlspecialchars($options[$answer['correct_answer']]); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-4">
                        <i class="fas fa-question-circle fa-3x text-muted mb-3"></i>
                        <h6 class="text-muted">No detailed answers available</h6>
                        <p class="text-muted">This may be due to an error during test submission.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Certificate Download Section -->
<div class="row mt-4">
    <div class="col-12 text-center">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Download Certificate</h5>
                <p class="card-text">Generate a PDF certificate of your test results</p>
                <button class="btn btn-primary" onclick="downloadCertificate()">
                    <i class="fas fa-download me-2"></i>Download PDF Certificate
                </button>
            </div>
        </div>
    </div>
</div>

<style>
.result-summary {
    border: 2px solid var(--primary-color);
}

.result-stat h3 {
    font-size: 2.5rem;
    font-weight: bold;
}

.result-stat p {
    font-size: 0.9rem;
    margin-bottom: 0;
}

.accordion-button:not(.collapsed) {
    background-color: transparent;
    box-shadow: none;
}

.accordion-button:focus {
    box-shadow: none;
}

@media (max-width: 768px) {
    .result-stat h3 {
        font-size: 2rem;
    }
}
</style>

<script>
function downloadCertificate() {
    // This would typically generate a PDF certificate
    // For now, we'll show a simple alert
    Swal.fire({
        icon: 'info',
        title: 'Coming Soon',
        text: 'Certificate download feature will be available soon. This would generate a PDF certificate with your test results.',
        confirmButtonText: 'OK'
    });
}

// Auto-expand first accordion item
document.addEventListener('DOMContentLoaded', function() {
    const firstAccordion = document.querySelector('#answerAccordion .accordion-item:first-child .accordion-button');
    if (firstAccordion) {
        firstAccordion.click();
    }
});
</script>

<?php include '../includes/footer.php'; ?>