<?php
session_start();
require_once '../config/database.php';
require_once '../includes/mail.php';

// Check if user is admin
if (!isAdmin()) {
    header('Location: ../login.php');
    exit;
}

$message = '';
$message_type = '';

if ($_POST) {
    $test_email = sanitize($_POST['test_email']);
    $test_name = sanitize($_POST['test_name']);
    
    if (empty($test_email) || !filter_var($test_email, FILTER_VALIDATE_EMAIL)) {
        $message = 'Please enter a valid email address.';
        $message_type = 'danger';
    } else {
        $mailHelper = new MailHelper();
        
        $subject = 'OACSOFT CBT System - Email Test';
        $email_message = "
        <!DOCTYPE html>
        <html>
        <head>
            <meta charset='UTF-8'>
            <title>Email Test</title>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: #007bff; color: white; padding: 20px; text-align: center; }
                .content { padding: 20px; background: #f8f9fa; }
                .test-box { background: white; padding: 15px; margin: 10px 0; border-radius: 5px; border-left: 4px solid #28a745; }
                .footer { text-align: center; padding: 20px; color: #666; }
            </style>
        </head>
        <body>
            <div class='container'>
                <div class='header'>
                    <h1>OACSOFT CBT System</h1>
                    <p>Email Configuration Test</p>
                </div>
                <div class='content'>
                    <h2>Hello $test_name,</h2>
                    <p>This is a test email to verify that the SMTP configuration is working correctly.</p>
                    
                    <div class='test-box'>
                        <h3>✅ Email Test Successful</h3>
                        <p><strong>SMTP Host:</strong> " . EMAIL_HOST . "</p>
                        <p><strong>SMTP Port:</strong> " . EMAIL_PORT . "</p>
                        <p><strong>From Email:</strong> " . FROM_EMAIL . "</p>
                        <p><strong>Test Time:</strong> " . date('M d, Y H:i:s') . "</p>
                    </div>
                    
                    <p>If you received this email, your SMTP configuration is working properly and the CBT system can send emails successfully.</p>
                </div>
                <div class='footer'>
                    <p>Best regards,<br>OACSOFT CBT Team</p>
                    <p><small>This is a test message from the CBT system.</small></p>
                </div>
            </div>
        </body>
        </html>
        ";
        
        $result = $mailHelper->sendEmail($test_email, $test_name, $subject, $email_message, true);
        
        if ($result['success']) {
            $message = 'Test email sent successfully to ' . $test_email . '! Please check the inbox (and spam folder).';
            $message_type = 'success';
        } else {
            $message = 'Failed to send test email: ' . $result['message'];
            $message_type = 'danger';
        }
    }
}

include '../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-envelope-open-text me-2"></i>Email Configuration Test</h2>
    <a href="test-sessions.php" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i>Back to Sessions
    </a>
</div>

            <?php if ($message): ?>
                <div class="alert alert-<?php echo $message_type; ?> alert-dismissible fade show" role="alert">
                    <?php echo $message; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="fas fa-paper-plane me-2"></i>Send Test Email</h5>
                        </div>
                        <div class="card-body">
                            <p class="text-muted mb-4">Use this form to test if your SMTP email configuration is working correctly. A test email will be sent to the specified address.</p>
                            
                            <form method="POST">
                                <div class="mb-3">
                                    <label for="test_name" class="form-label">Recipient Name</label>
                                    <input type="text" class="form-control" id="test_name" name="test_name" 
                                           value="<?php echo isset($_POST['test_name']) ? htmlspecialchars($_POST['test_name']) : 'Test User'; ?>" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="test_email" class="form-label">Test Email Address</label>
                                    <input type="email" class="form-control" id="test_email" name="test_email" 
                                           value="<?php echo isset($_POST['test_email']) ? htmlspecialchars($_POST['test_email']) : ''; ?>" 
                                           placeholder="Enter email address to test" required>
                                    <div class="form-text">Enter the email address where you want to send the test email.</div>
                                </div>
                                
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-paper-plane me-2"></i>Send Test Email
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="fas fa-cog me-2"></i>Current SMTP Settings</h5>
                        </div>
                        <div class="card-body">
                            <table class="table table-sm table-borderless">
                                <tr>
                                    <td><strong>SMTP Host:</strong></td>
                                    <td><?php echo EMAIL_HOST; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>SMTP Port:</strong></td>
                                    <td><?php echo EMAIL_PORT; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Username:</strong></td>
                                    <td><?php echo EMAIL_USERNAME; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>From Email:</strong></td>
                                    <td><?php echo FROM_EMAIL; ?></td>
                                </tr>
                                <tr>
                                    <td><strong>From Name:</strong></td>
                                    <td><?php echo FROM_NAME; ?></td>
                                </tr>
                            </table>
                            
                            <div class="alert alert-info mt-3">
                                <small><i class="fas fa-info-circle me-1"></i>
                                These settings are configured in <code>config/database.php</code></small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card mt-3">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="fas fa-question-circle me-2"></i>Troubleshooting</h5>
                        </div>
                        <div class="card-body">
                            <ul class="list-unstyled small">
                                <li><i class="fas fa-check text-success me-2"></i>Verify SMTP credentials</li>
                                <li><i class="fas fa-check text-success me-2"></i>Check firewall settings</li>
                                <li><i class="fas fa-check text-success me-2"></i>Ensure port 587 is open</li>
                                <li><i class="fas fa-check text-success me-2"></i>Check spam/junk folder</li>
                                <li><i class="fas fa-check text-success me-2"></i>Verify email server settings</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Fix responsive layout issues */
.container {
    max-width: 100%;
    padding-left: 15px;
    padding-right: 15px;
}

@media (min-width: 576px) {
    .container {
        max-width: 540px;
    }
}

@media (min-width: 768px) {
    .container {
        max-width: 720px;
    }
}

@media (min-width: 992px) {
    .container {
        max-width: 960px;
    }
}

@media (min-width: 1200px) {
    .container {
        max-width: 1140px;
    }
}

@media (min-width: 1400px) {
    .container {
        max-width: 1320px;
    }
}

/* Ensure proper navbar behavior */
.navbar-collapse {
    flex-basis: 100%;
    flex-grow: 1;
    align-items: center;
}

/* Fix card responsiveness */
.card {
    margin-bottom: 1rem;
}

@media (max-width: 767px) {
    .d-flex.justify-content-between {
        flex-direction: column;
        gap: 1rem;
    }
    
    .d-flex.justify-content-between > div {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
    }
    
    .row {
        margin-left: 0;
        margin-right: 0;
    }
    
    .col-md-8, .col-md-4 {
        padding-left: 0;
        padding-right: 0;
    }
}
</style>

<?php include '../includes/footer.php'; ?>