<?php 
include '../includes/header.php';
require_once '../includes/test-invitation-template.php';

if (!isAdmin()) {
    redirect('../login.php');
}

// Sample data for preview
$sampleCandidate = [
    'full_name' => 'John Doe',
    'email' => 'john.doe@example.com'
];

$sampleSession = [
    'access_code' => 'CBT2024001',
    'scheduled_time' => date('Y-m-d H:i:s', strtotime('+2 days')),
    'duration_minutes' => 60,
    'total_questions' => 25,
    'total_marks' => 100
];

$sampleJobRole = [
    'role_name' => 'Software Developer',
    'description' => 'Full Stack Developer Position'
];

$emailContent = generateTestInvitationEmail($sampleCandidate, $sampleSession, $sampleJobRole);
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>
        <i class="fas fa-eye me-2"></i>
        Email Template Preview
    </h2>
    <div>
        <a href="test-sessions.php" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i>Back to Sessions
        </a>
        <button class="btn btn-primary" onclick="window.print()">
            <i class="fas fa-print me-1"></i>Print Preview
        </button>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-envelope me-2"></i>
            Test Invitation Email Template
        </h5>
        <small class="text-muted">This is how the invitation email will appear to candidates</small>
    </div>
    <div class="card-body p-0">
        <div class="alert alert-info m-3">
            <i class="fas fa-info-circle me-2"></i>
            <strong>Preview Note:</strong> This is a sample email with dummy data. The actual email will contain real candidate and test session information.
        </div>
        
        <!-- Email Preview Container -->
        <div style="background-color: #f4f4f4; padding: 20px;">
            <?php echo $emailContent; ?>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="fas fa-cog me-2"></i>
                    Email Configuration
                </h6>
            </div>
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-md-6 col-12">
                        <strong>SMTP Host:</strong>
                    </div>
                    <div class="col-md-6 col-12">
                        <?php echo defined('EMAIL_HOST') ? EMAIL_HOST : 'Not configured'; ?>
                    </div>
                </div>
                <hr>
                <div class="row mb-2">
                    <div class="col-md-6 col-12">
                        <strong>SMTP Port:</strong>
                    </div>
                    <div class="col-md-6 col-12">
                        <?php echo defined('EMAIL_PORT') ? EMAIL_PORT : 'Not configured'; ?>
                    </div>
                </div>
                <hr>
                <div class="row mb-2">
                    <div class="col-md-6 col-12">
                        <strong>From Email:</strong>
                    </div>
                    <div class="col-md-6 col-12">
                        <?php echo defined('FROM_EMAIL') ? FROM_EMAIL : 'Not configured'; ?>
                    </div>
                </div>
                <hr>
                <div class="row mb-2">
                    <div class="col-md-6 col-12">
                        <strong>From Name:</strong>
                    </div>
                    <div class="col-md-6 col-12">
                        <?php echo defined('FROM_NAME') ? FROM_NAME : 'Not configured'; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="fas fa-list me-2"></i>
                    Email Features
                </h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Professional HTML design
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Complete test details
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Step-by-step instructions
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Terms and conditions
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Contact information
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Mobile responsive design
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Plain text fallback
                    </li>
                    <li class="mb-2">
                        <i class="fas fa-check text-success me-2"></i>
                        Automatic sending on session creation
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<style>
/* Fix responsive layout issues */
.container {
    max-width: 100%;
    padding-left: 15px;
    padding-right: 15px;
}

@media (min-width: 576px) {
    .container {
        max-width: 540px;
    }
}

@media (min-width: 768px) {
    .container {
        max-width: 720px;
    }
}

@media (min-width: 992px) {
    .container {
        max-width: 960px;
    }
}

@media (min-width: 1200px) {
    .container {
        max-width: 1140px;
    }
}

@media (min-width: 1400px) {
    .container {
        max-width: 1320px;
    }
}

/* Ensure proper navbar behavior */
.navbar-collapse {
    flex-basis: 100%;
    flex-grow: 1;
    align-items: center;
}

/* Fix card responsiveness */
.card {
    margin-bottom: 1rem;
}

@media (max-width: 767px) {
    .d-flex.justify-content-between {
        flex-direction: column;
        gap: 1rem;
    }
    
    .d-flex.justify-content-between > div {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
    }
}

@media print {
    .card-header, .btn, .alert {
        display: none !important;
    }
    .card {
        border: none !important;
        box-shadow: none !important;
    }
}
</style>

<?php include '../includes/footer.php'; ?>