<?php 
include '../includes/header.php'; 

if (!isAdmin()) {
    redirect('../login.php');
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add':
                $role_name = sanitize($_POST['role_name']);
                $description = sanitize($_POST['description']);
                
                if (empty($role_name)) {
                    $_SESSION['error_message'] = "Role name is required";
                } else {
                    $stmt = $conn->prepare("INSERT INTO job_roles (role_name, description) VALUES (?, ?)");
                    if ($stmt->execute([$role_name, $description])) {
                        $_SESSION['success_message'] = "Job role added successfully";
                    } else {
                        $_SESSION['error_message'] = "Failed to add job role";
                    }
                }
                break;
                
            case 'edit':
                $id = $_POST['id'];
                $role_name = sanitize($_POST['role_name']);
                $description = sanitize($_POST['description']);
                
                if (empty($role_name)) {
                    $_SESSION['error_message'] = "Role name is required";
                } else {
                    $stmt = $conn->prepare("UPDATE job_roles SET role_name = ?, description = ? WHERE id = ?");
                    if ($stmt->execute([$role_name, $description, $id])) {
                        $_SESSION['success_message'] = "Job role updated successfully";
                    } else {
                        $_SESSION['error_message'] = "Failed to update job role";
                    }
                }
                break;
                
            case 'delete':
                $id = $_POST['id'];
                $stmt = $conn->prepare("DELETE FROM job_roles WHERE id = ?");
                if ($stmt->execute([$id])) {
                    $_SESSION['success_message'] = "Job role deleted successfully";
                } else {
                    $_SESSION['error_message'] = "Failed to delete job role";
                }
                break;
        }
        header('Location: job-roles.php');
        exit;
    }
}

// Fetch all job roles with question count
$stmt = $conn->query("SELECT jr.*, COUNT(q.id) as question_count 
                     FROM job_roles jr 
                     LEFT JOIN questions q ON jr.id = q.job_role_id 
                     GROUP BY jr.id 
                     ORDER BY jr.role_name");
$job_roles = $stmt->fetchAll();

// Get role for editing
$edit_role = null;
if (isset($_GET['edit'])) {
    $stmt = $conn->prepare("SELECT * FROM job_roles WHERE id = ?");
    $stmt->execute([$_GET['edit']]);
    $edit_role = $stmt->fetch();
}
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>
        <i class="fas fa-briefcase me-2"></i>
        Job Roles Management
    </h2>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addRoleModal">
        <i class="fas fa-plus me-2"></i>Add New Role
    </button>
</div>

<?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['success_message']; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php unset($_SESSION['success_message']); ?>
<?php endif; ?>

<?php if (isset($_SESSION['error_message'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['error_message']; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php unset($_SESSION['error_message']); ?>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Job Roles</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover" id="rolesTable">
                <thead>
                    <tr>
                        <th>Role Name</th>
                        <th>Description</th>
                        <th>Questions</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($job_roles as $role): ?>
                        <tr>
                            <td>
                                <strong><?php echo htmlspecialchars($role['role_name']); ?></strong>
                            </td>
                            <td>
                                <?php echo htmlspecialchars(substr($role['description'], 0, 100)); ?>
                                <?php echo strlen($role['description']) > 100 ? '...' : ''; ?>
                            </td>
                            <td>
                                <span class="badge bg-info">
                                    <?php echo $role['question_count']; ?> questions
                                </span>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    <a href="questions.php?role=<?php echo $role['id']; ?>" 
                                       class="btn btn-sm btn-primary" 
                                       title="Manage Questions">
                                        <i class="fas fa-question-circle"></i>
                                    </a>
                                    <button class="btn btn-sm btn-warning" 
                                            onclick="editRole(<?php echo $role['id']; ?>, '<?php echo addslashes($role['role_name']); ?>', '<?php echo addslashes($role['description']); ?>')"
                                            title="Edit Role">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger" 
                                            onclick="deleteRole(<?php echo $role['id']; ?>, '<?php echo addslashes($role['role_name']); ?>')"
                                            title="Delete Role">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Add Role Modal -->
<div class="modal fade" id="addRoleModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Job Role</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="role_name" class="form-label">Role Name *</label>
                        <input type="text" 
                               class="form-control" 
                               id="role_name" 
                               name="role_name" 
                               required>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" 
                                  id="description" 
                                  name="description" 
                                  rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Role</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Role Modal -->
<div class="modal fade" id="editRoleModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Job Role</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" id="edit_role_id">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_role_name" class="form-label">Role Name *</label>
                        <input type="text" 
                               class="form-control" 
                               id="edit_role_name" 
                               name="role_name" 
                               required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_description" class="form-label">Description</label>
                        <textarea class="form-control" 
                                  id="edit_description" 
                                  name="description" 
                                  rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Role</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editRole(id, name, description) {
    document.getElementById('edit_role_id').value = id;
    document.getElementById('edit_role_name').value = name;
    document.getElementById('edit_description').value = description;
    new bootstrap.Modal(document.getElementById('editRoleModal')).show();
}

function deleteRole(id, name) {
    if (confirm(`Are you sure you want to delete the job role "${name}"? This will also delete all questions for this role.`)) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="${id}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php include '../includes/footer.php'; ?>