<?php 
include '../includes/header.php';

if (!isAdmin()) {
    redirect('../login.php');
}
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>
        <i class="fas fa-book me-2"></i>
        Email System Guide
    </h2>
    <a href="test-sessions.php" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i>Back to Sessions
    </a>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-envelope me-2"></i>
                    Automatic Email Invitations
                </h5>
            </div>
            <div class="card-body">
                <h6 class="text-primary">How It Works</h6>
                <p>When you create a new test session, the system automatically sends a comprehensive invitation email to the candidate with all the necessary information to take their test.</p>
                
                <h6 class="text-primary mt-4">Email Content Includes:</h6>
                <div class="row">
                    <div class="col-md-6">
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Personalized greeting</li>
                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Job role information</li>
                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Test date and time</li>
                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Duration and question count</li>
                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Total marks and passing score</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <ul class="list-unstyled">
                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Unique access code</li>
                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Step-by-step instructions</li>
                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Terms and conditions</li>
                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Support contact information</li>
                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Direct link to test portal</li>
                        </ul>
                    </div>
                </div>
                
                <h6 class="text-primary mt-4">Email Features:</h6>
                <div class="alert alert-info">
                    <ul class="mb-0">
                        <li><strong>Professional Design:</strong> Modern, responsive HTML template that works on all devices</li>
                        <li><strong>Dual Format:</strong> Both HTML and plain text versions for maximum compatibility</li>
                        <li><strong>Security:</strong> Access codes are prominently displayed and secured</li>
                        <li><strong>User-Friendly:</strong> Clear instructions and visual hierarchy</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-cogs me-2"></i>
                    System Configuration
                </h5>
            </div>
            <div class="card-body">
                <h6 class="text-primary">SMTP Settings</h6>
                <p>The email system uses SMTP configuration defined in <code>config/database.php</code>:</p>
                
                <div class="table-responsive">
                    <table class="table table-sm">
                        <tr>
                            <td><strong>SMTP Host:</strong></td>
                            <td><?php echo defined('EMAIL_HOST') ? '<span class="text-success">' . EMAIL_HOST . '</span>' : '<span class="text-danger">Not configured</span>'; ?></td>
                        </tr>
                        <tr>
                            <td><strong>SMTP Port:</strong></td>
                            <td><?php echo defined('EMAIL_PORT') ? '<span class="text-success">' . EMAIL_PORT . '</span>' : '<span class="text-danger">Not configured</span>'; ?></td>
                        </tr>
                        <tr>
                            <td><strong>SMTP Username:</strong></td>
                            <td><?php echo defined('EMAIL_USERNAME') ? '<span class="text-success">Configured</span>' : '<span class="text-danger">Not configured</span>'; ?></td>
                        </tr>
                        <tr>
                            <td><strong>From Email:</strong></td>
                            <td><?php echo defined('FROM_EMAIL') ? '<span class="text-success">' . FROM_EMAIL . '</span>' : '<span class="text-danger">Not configured</span>'; ?></td>
                        </tr>
                        <tr>
                            <td><strong>From Name:</strong></td>
                            <td><?php echo defined('FROM_NAME') ? '<span class="text-success">' . FROM_NAME . '</span>' : '<span class="text-danger">Not configured</span>'; ?></td>
                        </tr>
                    </table>
                </div>
                
                <div class="alert alert-warning mt-3">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Note:</strong> If email sending fails, the test session will still be created successfully, but you'll need to manually inform the candidate.
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="fas fa-tools me-2"></i>
                    Quick Actions
                </h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="test-email.php" class="btn btn-outline-primary">
                        <i class="fas fa-paper-plane me-2"></i>Test SMTP Settings
                    </a>
                    <a href="preview-invitation-email.php" class="btn btn-outline-info">
                        <i class="fas fa-eye me-2"></i>Preview Email Template
                    </a>
                    <a href="test-sessions.php" class="btn btn-outline-success">
                        <i class="fas fa-plus me-2"></i>Create Test Session
                    </a>
                </div>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="fas fa-question-circle me-2"></i>
                    Troubleshooting
                </h6>
            </div>
            <div class="card-body">
                <h6 class="text-primary">Common Issues:</h6>
                
                <div class="mb-3">
                    <strong>Email not sending:</strong>
                    <ul class="small mt-1">
                        <li>Check SMTP configuration</li>
                        <li>Verify internet connection</li>
                        <li>Test with SMTP test tool</li>
                        <li>Check server logs</li>
                    </ul>
                </div>
                
                <div class="mb-3">
                    <strong>Email in spam folder:</strong>
                    <ul class="small mt-1">
                        <li>Configure SPF records</li>
                        <li>Set up DKIM authentication</li>
                        <li>Use reputable SMTP service</li>
                    </ul>
                </div>
                
                <div class="mb-3">
                    <strong>Template not displaying correctly:</strong>
                    <ul class="small mt-1">
                        <li>Check email client compatibility</li>
                        <li>Verify HTML structure</li>
                        <li>Test with different email clients</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Best Practices
                </h6>
            </div>
            <div class="card-body">
                <ul class="small">
                    <li>Always test email settings before creating sessions</li>
                    <li>Schedule tests at least 24 hours in advance</li>
                    <li>Verify candidate email addresses are correct</li>
                    <li>Keep backup communication methods ready</li>
                    <li>Monitor email delivery status</li>
                    <li>Follow up with candidates if needed</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<style>
/* Fix responsive layout issues */
.container {
    max-width: 100%;
    padding-left: 15px;
    padding-right: 15px;
}

@media (min-width: 576px) {
    .container {
        max-width: 540px;
    }
}

@media (min-width: 768px) {
    .container {
        max-width: 720px;
    }
}

@media (min-width: 992px) {
    .container {
        max-width: 960px;
    }
}

@media (min-width: 1200px) {
    .container {
        max-width: 1140px;
    }
}

@media (min-width: 1400px) {
    .container {
        max-width: 1320px;
    }
}

/* Ensure proper navbar behavior */
.navbar-collapse {
    flex-basis: 100%;
    flex-grow: 1;
    align-items: center;
}

/* Fix card responsiveness */
.card {
    margin-bottom: 1rem;
}

@media (max-width: 767px) {
    .d-flex.justify-content-between {
        flex-direction: column;
        gap: 1rem;
    }
    
    .d-flex.justify-content-between > div {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
    }
    
    .row {
        margin-left: 0;
        margin-right: 0;
    }
    
    .col-lg-8, .col-lg-4, .col-md-6 {
        padding-left: 0;
        padding-right: 0;
    }
}
</style>

<?php include '../includes/footer.php'; ?>