<?php 
include '../includes/header.php'; 

if (!isAdmin()) {
    redirect('../login.php');
}

// Get dashboard statistics
$stats = [];

// Total users
$stmt = $conn->query("SELECT COUNT(*) as total FROM users WHERE role = 'candidate'");
$stats['total_users'] = $stmt->fetch()['total'];

// Pending approvals
$stmt = $conn->query("SELECT COUNT(*) as pending FROM users WHERE status = 'pending'");
$stats['pending_users'] = $stmt->fetch()['pending'];

// Total job roles
$stmt = $conn->query("SELECT COUNT(*) as total FROM job_roles");
$stats['total_roles'] = $stmt->fetch()['total'];

// Total questions
$stmt = $conn->query("SELECT COUNT(*) as total FROM questions");
$stats['total_questions'] = $stmt->fetch()['total'];

// Active test sessions
$stmt = $conn->query("SELECT COUNT(*) as active FROM test_sessions WHERE status = 'scheduled'");
$stats['active_sessions'] = $stmt->fetch()['active'];

// Completed tests this month
$stmt = $conn->query("SELECT COUNT(*) as completed FROM test_results WHERE MONTH(completed_at) = MONTH(CURRENT_DATE())");
$stats['completed_this_month'] = $stmt->fetch()['completed'];

// Recent users
$stmt = $conn->query("SELECT * FROM users WHERE role = 'candidate' ORDER BY created_at DESC LIMIT 5");
$recent_users = $stmt->fetchAll();

// Recent test results
$stmt = $conn->query("SELECT tr.*, u.full_name, jr.role_name 
                     FROM test_results tr 
                     JOIN test_sessions ts ON tr.session_id = ts.id 
                     JOIN users u ON ts.user_id = u.id 
                     JOIN job_roles jr ON ts.job_role_id = jr.id 
                     ORDER BY tr.completed_at DESC 
                     LIMIT 5");
$recent_results = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>
        <i class="fas fa-tachometer-alt me-2"></i>
        Admin Dashboard
    </h2>
    <div>
        <a href="users.php" class="btn btn-primary">
            <i class="fas fa-users me-1"></i>Manage Users
        </a>
        <a href="test-sessions.php" class="btn btn-success">
            <i class="fas fa-play-circle me-1"></i>Create Session
        </a>
    </div>
</div>

<!-- Statistics Cards -->
<div class="dashboard-stats">
    <div class="stat-card">
        <div class="stat-number"><?php echo $stats['total_users']; ?></div>
        <div class="stat-label">Total Candidates</div>
    </div>
    <div class="stat-card">
        <div class="stat-number"><?php echo $stats['pending_users']; ?></div>
        <div class="stat-label">Pending Approvals</div>
    </div>
    <div class="stat-card">
        <div class="stat-number"><?php echo $stats['total_roles']; ?></div>
        <div class="stat-label">Job Roles</div>
    </div>
    <div class="stat-card">
        <div class="stat-number"><?php echo $stats['total_questions']; ?></div>
        <div class="stat-label">Total Questions</div>
    </div>
    <div class="stat-card">
        <div class="stat-number"><?php echo $stats['active_sessions']; ?></div>
        <div class="stat-label">Active Sessions</div>
    </div>
    <div class="stat-card">
        <div class="stat-number"><?php echo $stats['completed_this_month']; ?></div>
        <div class="stat-label">Tests This Month</div>
    </div>
</div>

<div class="row">
    <!-- Recent Users -->
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-users me-2"></i>
                    Recent Registrations
                </h5>
            </div>
            <div class="card-body">
                <?php if (count($recent_users) > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_users as $user): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($user['full_name']); ?></td>
                                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                                        <td>
                                            <span class="badge status-<?php echo $user['status']; ?>">
                                                <?php echo ucfirst($user['status']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if ($user['status'] === 'pending'): ?>
                                                <button class="btn btn-sm btn-success" 
                                                        onclick="approveUser(<?php echo $user['id']; ?>)">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                                <button class="btn btn-sm btn-danger" 
                                                        onclick="rejectUser(<?php echo $user['id']; ?>)">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="text-center mt-3">
                        <a href="users.php" class="btn btn-primary btn-sm">
                            View All Users
                        </a>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center">No recent registrations</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Recent Test Results -->
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Recent Test Results
                </h5>
            </div>
            <div class="card-body">
                <?php if (count($recent_results) > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Candidate</th>
                                    <th>Role</th>
                                    <th>Score</th>
                                    <th>Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_results as $result): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($result['full_name']); ?></td>
                                        <td><?php echo htmlspecialchars($result['role_name']); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo $result['percentage'] >= 70 ? 'success' : ($result['percentage'] >= 50 ? 'warning' : 'danger'); ?>">
                                                <?php echo $result['percentage']; ?>%
                                            </span>
                                        </td>
                                        <td><?php echo date('M j, Y', strtotime($result['completed_at'])); ?></td>
                                        <td>
                                            <?php if (!$result['email_sent']): ?>
                                                <button class="btn btn-sm btn-info" 
                                                        onclick="sendResultEmail(<?php echo $result['id']; ?>)">
                                                    <i class="fas fa-envelope"></i>
                                                </button>
                                            <?php else: ?>
                                                <span class="text-success">
                                                    <i class="fas fa-check"></i>
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="text-center mt-3">
                        <a href="results.php" class="btn btn-primary btn-sm">
                            View All Results
                        </a>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center">No test results yet</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Quick Actions -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-bolt me-2"></i>
                    Quick Actions
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <a href="users.php" class="btn btn-outline-primary w-100">
                            <i class="fas fa-users me-2"></i>
                            Manage Users
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="job-roles.php" class="btn btn-outline-success w-100">
                            <i class="fas fa-briefcase me-2"></i>
                            Job Roles
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="questions.php" class="btn btn-outline-info w-100">
                            <i class="fas fa-question-circle me-2"></i>
                            Questions
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="test-sessions.php" class="btn btn-outline-warning w-100">
                            <i class="fas fa-play-circle me-2"></i>
                            Test Sessions
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>