# Computer-Based Test (CBT) System

A comprehensive web-based Computer-Based Test (CBT) system developed for OACSOFT TECHNOLOGIES LTD. This system allows organizations to conduct online assessments for job candidates across different roles and positions.

## Features

### For Administrators
- **User Management**: Manage candidate accounts with approval/rejection workflow
- **Job Role Management**: Create and manage job roles for different positions
- **Question Management**: Add, edit, and delete questions for each job role
- **Test Session Management**: Create test sessions with access codes and scheduling
- **Results Management**: View detailed test results and send email notifications
- **Dashboard Analytics**: Overview of system statistics and recent activities

### For Candidates
- **Registration**: Self-registration with email verification
- **Test Scheduling**: View scheduled test sessions
- **Test Interface**: Interactive test-taking experience with timer and navigation
- **Results Review**: Detailed feedback on test performance
- **Certificate Generation**: Downloadable certificates for completed tests

### Technical Features
- **Responsive Design**: Works on desktop, tablet, and mobile devices
- **Real-time Timer**: Automatic test submission when time expires
- **Auto-save**: Answers are automatically saved during the test
- **Progress Tracking**: Visual progress indicators during tests
- **Security**: Access code-based test access and anti-cheating measures
- **Email Integration**: Automated email notifications for results

## Technology Stack

- **Backend**: PHP 8.0+
- **Database**: MySQL 5.7+
- **Frontend**: HTML5, CSS3, JavaScript (ES6+)
- **CSS Framework**: Bootstrap 5.3
- **Icons**: Font Awesome 6.0
- **Database Library**: PDO (PHP Data Objects)
- **AJAX**: Vanilla JavaScript for real-time interactions

## Installation Guide

### Prerequisites
- PHP 8.0 or higher
- MySQL 5.7 or higher
- Web server (Apache/Nginx)
- Composer (for dependency management)

### Step 1: Database Setup
1. Create a new MySQL database named `cbt_system`
2. Import the database schema:
   ```bash
   mysql -u username -p cbt_system < database.sql
   ```

### Step 2: Configuration
1. Copy the project files to your web server directory
2. Update database configuration in `config/database.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'cbt_system');
   define('DB_USER', 'your_username');
   define('DB_PASS', 'your_password');
   ```

### Step 3: File Permissions
Ensure the following directories have write permissions:
- `assets/uploads/` (if file uploads are enabled)
- `logs/` (if logging is enabled)

### Step 4: Email Configuration
Update email settings in `config/database.php` for result notifications:
```php
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USER', 'your-email@gmail.com');
define('SMTP_PASS', 'your-app-password');
```

## Usage Guide

### For Administrators

#### 1. Initial Setup
- Login with admin credentials (default: admin@example.com / admin123)
- Navigate to Admin Dashboard
- Create job roles for different positions
- Add questions for each job role

#### 2. Managing Users
- Go to Users Management
- Review pending registrations
- Approve or reject candidates
- View user details and test history

#### 3. Creating Test Sessions
- Navigate to Test Sessions
- Click "Create New Session"
- Select candidate and job role
- Set scheduled time and duration
- System generates unique access code

#### 4. Monitoring Results
- View completed tests in dashboard
- Access detailed results with answer breakdown
- Send results via email to candidates
- Generate reports for analysis

### For Candidates

#### 1. Registration
- Visit the registration page
- Fill in personal details
- Submit registration form
- Wait for admin approval

#### 2. Taking Tests
- Login with approved credentials
- View available test sessions
- Enter access code when prompted
- Complete test within time limit
- Review results after completion

## Database Schema

### Core Tables
- **users**: User accounts (candidates and admins)
- **job_roles**: Available job positions
- **questions**: Test questions for each role
- **test_sessions**: Scheduled test sessions
- **results**: Test results and scores
- **user_answers**: Detailed answer records

### Key Relationships
- Users can have multiple test sessions
- Job roles can have multiple questions
- Test sessions link users to specific job roles
- Results are generated from completed test sessions

## Security Features

- **Password Hashing**: All passwords are hashed using bcrypt
- **SQL Injection Prevention**: Prepared statements throughout
- **XSS Protection**: Output sanitization and escaping
- **CSRF Protection**: Token-based form protection
- **Access Control**: Role-based permission system
- **Session Management**: Secure session handling
- **Input Validation**: Comprehensive validation on all inputs

## Configuration Options

### Test Settings
- **Passing Score**: Configurable (default: 70%)
- **Test Duration**: Set per session (15-180 minutes)
- **Question Count**: Flexible per job role
- **Randomization**: Questions can be randomized

### System Settings
- **Registration**: Enable/disable self-registration
- **Email Notifications**: Configure result emails
- **Test Attempts**: Limit attempts per candidate
- **Time Zones**: Support for different time zones

## Troubleshooting

### Common Issues

#### Database Connection Error
- Check database credentials in config/database.php
- Ensure MySQL service is running
- Verify database exists and user has permissions

#### Email Not Working
- Check SMTP configuration
- Verify email credentials
- Check spam folders

#### Test Timer Issues
- Ensure JavaScript is enabled in browser
- Check server time synchronization
- Verify session timeout settings

#### Access Code Problems
- Verify access code is correct
- Check if test time has started
- Ensure candidate is approved

### Browser Compatibility
- Chrome 80+
- Firefox 75+
- Safari 13+
- Edge 80+
- Mobile browsers (iOS Safari, Chrome Mobile)

## API Endpoints (Future Enhancement)

The system includes RESTful API endpoints for:
- User management
- Question management
- Test session creation
- Results retrieval
- Report generation

## Support and Maintenance

### Regular Tasks
- **Backup Database**: Daily automated backups
- **Monitor Logs**: Check error logs weekly
- **Update Questions**: Regular review and updates
- **User Management**: Review pending registrations

### Performance Optimization
- **Database Indexing**: Optimized queries with proper indexes
- **Caching**: Static asset caching for faster loading
- **CDN**: Use CDN for static resources
- **Database Cleanup**: Regular cleanup of old sessions

## License

This project is proprietary software developed for OACSOFT TECHNOLOGIES LTD. All rights reserved.

## Contact Information

For technical support or questions:
- Email: support@oacsoft.com
- Phone: +234-XXX-XXX-XXXX
- Documentation: [Internal Wiki Link]

## Version History

- **v1.0.0** (2024-01-15): Initial release
- **v1.0.1** (2024-01-20): Bug fixes and performance improvements
- **v1.1.0** (2024-02-01): Added email notifications and certificate generation

---

**Last Updated**: January 2024  
**Developed by**: OACSOFT TECHNOLOGIES LTD Development Team